/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.vavr.Tuple0;
import io.vavr.Tuple1;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.Tuple4;
import io.vavr.Tuple5;
import io.vavr.Tuple6;
import io.vavr.Tuple7;
import io.vavr.jackson.datatype.deserialize.ValueDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class TupleDeserializer<T>
extends ValueDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;

    TupleDeserializer(JavaType valueType) {
        super(valueType, TupleDeserializer.arity(valueType));
        this.javaType = valueType;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int ptr = 0;
        JsonToken jsonToken = p.nextToken();
        while (jsonToken != JsonToken.END_ARRAY) {
            if (ptr >= this.deserializersCount()) {
                throw TupleDeserializer.mappingException(ctxt, this.javaType.getRawClass(), jsonToken);
            }
            JsonDeserializer<?> deserializer = this.deserializer(ptr++);
            Object value = jsonToken != JsonToken.VALUE_NULL ? deserializer.deserialize(p, ctxt) : deserializer.getNullValue(ctxt);
            list.add(value);
            jsonToken = p.nextToken();
        }
        if (list.size() == this.deserializersCount()) {
            return this.create(list, ctxt);
        }
        throw TupleDeserializer.mappingException(ctxt, this.javaType.getRawClass(), null);
    }

    abstract T create(List<Object> var1, DeserializationContext var2);

    private static int arity(JavaType valueType) {
        Class clz = valueType.getRawClass();
        if (clz == Tuple0.class) {
            return 0;
        }
        if (clz == Tuple1.class) {
            return 1;
        }
        if (clz == Tuple2.class) {
            return 2;
        }
        if (clz == Tuple3.class) {
            return 3;
        }
        if (clz == Tuple4.class) {
            return 4;
        }
        if (clz == Tuple5.class) {
            return 5;
        }
        if (clz == Tuple6.class) {
            return 6;
        }
        if (clz == Tuple7.class) {
            return 7;
        }
        return 8;
    }
}

