/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.jackson.datatype.serialize;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.vavr.Value;
import io.vavr.jackson.datatype.serialize.ValueSerializer;
import java.io.IOException;
import java.util.ArrayList;

class ArraySerializer<T extends Value<?>>
extends ValueSerializer<T>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final CollectionLikeType collectionType;

    ArraySerializer(CollectionLikeType collectionType, BeanProperty property) {
        super((JavaType)collectionType, property);
        this.collectionType = collectionType;
    }

    ArraySerializer(CollectionLikeType collectionType) {
        this(collectionType, null);
    }

    ArraySerializer(ArraySerializer<T> origin, BeanProperty property) {
        this(origin.collectionType, property);
    }

    @Override
    Object toJavaObj(T value) throws IOException {
        return value.toJavaList();
    }

    @Override
    JavaType emulatedJavaType(TypeFactory typeFactory) {
        return typeFactory.constructCollectionType(ArrayList.class, this.collectionType.getContentType());
    }

    public boolean isEmpty(SerializerProvider provider, T value) {
        return value.isEmpty();
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        if (property == this.beanProperty) {
            return this;
        }
        return new ArraySerializer<T>(this, property);
    }
}

