/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.match.generator;

import io.vavr.match.model.ClassModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class ImportManager {
    private final String packageNameOfClass;
    private List<String> directImports;
    private Map<FQN, Import> imports = new HashMap<FQN, Import>();

    private ImportManager(String packageNameOfClass, List<String> directImports) {
        this.packageNameOfClass = packageNameOfClass;
        this.directImports = directImports;
    }

    public static ImportManager forClass(ClassModel classModel, String ... directImports) {
        return new ImportManager(classModel.getPackageName(), ImportManager.reverseSort(directImports));
    }

    public String getType(ClassModel classModel) {
        FQN fqn = new FQN(classModel.getPackageName(), classModel.getClassName());
        return ImportManager.getType(fqn, this.imports, this.packageNameOfClass, this.directImports);
    }

    public String getType(String packageName, String className) {
        FQN fqn = new FQN(packageName, className);
        return ImportManager.getType(fqn, this.imports, this.packageNameOfClass, this.directImports);
    }

    public String getImports() {
        return ImportManager.optimizeImports(this.imports.values());
    }

    private static String getType(FQN fqn, Map<FQN, Import> imports, String packageNameOfClass, List<String> directImports) {
        if (fqn.packageName.isEmpty() && !packageNameOfClass.isEmpty()) {
            throw new IllegalStateException("Can't import class '" + fqn.className + "' located in default package");
        }
        if (fqn.packageName.equals(packageNameOfClass)) {
            Import _import = ImportManager.createImport(fqn, directImports);
            if (_import.type.equals(fqn.className)) {
                return fqn.className;
            }
            imports.put(fqn, _import);
            return _import.type;
        }
        if (imports.containsKey(fqn)) {
            return imports.get((Object)fqn).type;
        }
        Import _import = ImportManager.createImport(fqn, directImports);
        imports.put(fqn, _import);
        return _import.type;
    }

    private static Import createImport(FQN fqn, List<String> directImports) {
        String qualifiedName = fqn.qualifiedName();
        Optional<String> directImportOption = directImports.stream().filter(directImport -> qualifiedName.equals(directImport) || qualifiedName.startsWith(directImport + ".")).findFirst();
        if (directImportOption.isPresent()) {
            String directImport2 = directImportOption.get();
            if (qualifiedName.equals(directImport2)) {
                String type = directImport2.substring(directImport2.lastIndexOf(46) + 1);
                return new Import(directImport2, type);
            }
            String type = qualifiedName.substring(directImport2.length() + 1);
            int index = type.indexOf(".");
            String firstSegment = index < 0 ? type : type.substring(0, index);
            return new Import(directImport2 + "." + firstSegment, type);
        }
        int index = fqn.className.indexOf(".");
        String firstSegment = index < 0 ? fqn.className : fqn.className.substring(0, index);
        return new Import(fqn.packageName + "." + firstSegment, fqn.className);
    }

    private static String optimizeImports(Collection<Import> imports) {
        return imports.stream().filter(currentImport -> !currentImport.name.startsWith("java.lang.") || imports.stream().filter(otherImport -> !otherImport.equals(currentImport)).map(otherImport -> otherImport.type).filter(otherType -> otherType.equals(currentImport.type)).findFirst().isPresent()).map(_import -> _import.name).distinct().sorted().map(s -> "import " + s + ";").collect(Collectors.joining("\n"));
    }

    private static List<String> reverseSort(String[] strings) {
        String[] copy = new String[strings.length];
        System.arraycopy(strings, 0, copy, 0, strings.length);
        Arrays.sort(copy, Comparator.reverseOrder());
        return Arrays.asList(copy);
    }

    private static class FQN {
        private final String packageName;
        private final String className;

        FQN(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
        }

        String qualifiedName() {
            return this.packageName.isEmpty() ? this.className : this.packageName + "." + this.className;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof FQN && this.qualifiedName().equals(((FQN)o).qualifiedName());
        }

        public int hashCode() {
            return this.qualifiedName().hashCode();
        }

        public String toString() {
            return "FQN(" + this.packageName + ", " + this.className + ")";
        }
    }

    private static class Import {
        final String name;
        final String type;

        Import(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Import && this.toString().equals(o.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return "Import(" + this.name + ", " + this.type + ")";
        }
    }
}

