/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.test;

import io.vavr.Tuple;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.Objects;

public interface CheckResult {
    public boolean isSatisfied();

    public boolean isFalsified();

    public boolean isErroneous();

    public boolean isExhausted();

    public String propertyName();

    public int count();

    public Option<Tuple> sample();

    public Option<Error> error();

    default public void assertIsSatisfied() {
        if (!this.isSatisfied()) {
            throw new AssertionError((Object)("Expected satisfied check result but was " + this));
        }
    }

    default public void assertIsSatisfiedWithExhaustion(boolean exhausted) {
        if (!this.isSatisfied()) {
            throw new AssertionError((Object)("Expected satisfied check result but was " + this));
        }
        if (this.isExhausted() != exhausted) {
            throw new AssertionError((Object)("Expected satisfied check result to be " + (exhausted ? "" : "not ") + "exhausted but was: " + this));
        }
    }

    default public void assertIsFalsified() {
        if (!this.isFalsified()) {
            throw new AssertionError((Object)("Expected falsified check result but was " + this));
        }
    }

    default public void assertIsErroneous() {
        if (!this.isErroneous()) {
            throw new AssertionError((Object)("Expected erroneous check result but was " + this));
        }
    }

    public static class Erroneous
    implements CheckResult,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final int count;
        private final Error error;
        private final Option<Tuple> sample;

        Erroneous(String propertyName, int count, Error error, Option<Tuple> sample) {
            this.propertyName = propertyName;
            this.count = count;
            this.error = error;
            this.sample = sample;
        }

        @Override
        public boolean isSatisfied() {
            return false;
        }

        @Override
        public boolean isFalsified() {
            return false;
        }

        @Override
        public boolean isErroneous() {
            return true;
        }

        @Override
        public boolean isExhausted() {
            return false;
        }

        @Override
        public String propertyName() {
            return this.propertyName;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public Option<Tuple> sample() {
            return this.sample;
        }

        @Override
        public Option<Error> error() {
            return Option.some((Object)this.error);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Erroneous) {
                Erroneous that = (Erroneous)o;
                return Objects.equals(this.propertyName, that.propertyName) && this.count == that.count && this.deepEquals(this.error, that.error) && Objects.equals(this.sample, that.sample);
            }
            return false;
        }

        boolean deepEquals(Throwable t1, Throwable t2) {
            return t1 == null && t2 == null || t1 != null && t2 != null && Objects.equals(t1.getMessage(), t2.getMessage()) && this.deepEquals(t1.getCause(), t2.getCause());
        }

        public int hashCode() {
            return Objects.hash(this.propertyName, this.count, this.deepHashCode(this.error), this.sample);
        }

        int deepHashCode(Throwable t) {
            if (t == null) {
                return 0;
            }
            return Objects.hash(t.getMessage(), this.deepHashCode(t.getCause()));
        }

        public String toString() {
            return String.format("%s(propertyName = %s, count = %s, error = %s, sample = %s)", this.getClass().getSimpleName(), this.propertyName, this.count, this.error.getMessage(), this.sample);
        }
    }

    public static class Falsified
    implements CheckResult,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final int count;
        private final Tuple sample;

        Falsified(String propertyName, int count, Tuple sample) {
            this.propertyName = propertyName;
            this.count = count;
            this.sample = sample;
        }

        @Override
        public boolean isSatisfied() {
            return false;
        }

        @Override
        public boolean isFalsified() {
            return true;
        }

        @Override
        public boolean isErroneous() {
            return false;
        }

        @Override
        public boolean isExhausted() {
            return false;
        }

        @Override
        public String propertyName() {
            return this.propertyName;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public Option<Tuple> sample() {
            return Option.some((Object)this.sample);
        }

        @Override
        public Option<Error> error() {
            return Option.none();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Falsified) {
                Falsified that = (Falsified)o;
                return Objects.equals(this.propertyName, that.propertyName) && this.count == that.count && Objects.equals(this.sample, that.sample);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.propertyName, this.count, this.sample);
        }

        public String toString() {
            return String.format("%s(propertyName = %s, count = %s, sample = %s)", this.getClass().getSimpleName(), this.propertyName, this.count, this.sample);
        }
    }

    public static class Satisfied
    implements CheckResult,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final int count;
        private final boolean exhausted;

        Satisfied(String propertyName, int count, boolean exhausted) {
            this.propertyName = propertyName;
            this.count = count;
            this.exhausted = exhausted;
        }

        @Override
        public boolean isSatisfied() {
            return true;
        }

        @Override
        public boolean isFalsified() {
            return false;
        }

        @Override
        public boolean isErroneous() {
            return false;
        }

        @Override
        public boolean isExhausted() {
            return this.exhausted;
        }

        @Override
        public String propertyName() {
            return this.propertyName;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public Option<Tuple> sample() {
            return Option.none();
        }

        @Override
        public Option<Error> error() {
            return Option.none();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Satisfied) {
                Satisfied that = (Satisfied)o;
                return Objects.equals(this.propertyName, that.propertyName) && this.count == that.count && this.exhausted == that.exhausted;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.propertyName, this.count, this.exhausted);
        }

        public String toString() {
            return String.format("%s(propertyName = %s, count = %s, exhausted = %s)", this.getClass().getSimpleName(), this.propertyName, this.count, this.exhausted);
        }
    }
}

