/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.test;

import io.vavr.test.CheckResult;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;

@FunctionalInterface
public interface Checkable {
    public static final Supplier<Random> RNG = ThreadLocalRandom::current;
    public static final int DEFAULT_SIZE = 100;
    public static final int DEFAULT_TRIES = 1000;

    public CheckResult check(Random var1, int var2, int var3);

    default public CheckResult check(int size, int tries) {
        if (tries < 0) {
            throw new IllegalArgumentException("tries < 0");
        }
        return this.check(RNG.get(), size, tries);
    }

    default public CheckResult check() {
        return this.check(RNG.get(), 100, 1000);
    }

    default public Checkable and(Checkable checkable) {
        return (rng, size, tries) -> {
            CheckResult result = this.check(rng, size, tries);
            if (result.isSatisfied()) {
                return checkable.check(rng, size, tries);
            }
            return result;
        };
    }

    default public Checkable or(Checkable checkable) {
        return (rng, size, tries) -> {
            CheckResult result = this.check(rng, size, tries);
            if (result.isSatisfied()) {
                return result;
            }
            return checkable.check(rng, size, tries);
        };
    }
}

