package io.vertx.java.redis;

public enum RedisCommand {
	HMGET("HMGET"),
	HMSET("HMSET"),
	ZREVRANK("ZREVRANK"),
	PEXPIREAT("PEXPIREAT"),
	TTL("TTL"),
	SCRIPT_EXISTS("SCRIPT EXISTS"),
	SINTERSTORE("SINTERSTORE"),
	LASTSAVE("LASTSAVE"),
	STRLEN("STRLEN"),
	SMOVE("SMOVE"),
	UNWATCH("UNWATCH"),
	TYPE("TYPE"),
	SADD("SADD"),
	INCR("INCR"),
	BITCOUNT("BITCOUNT"),
	LSET("LSET"),
	MONITOR("MONITOR"),
	GET("GET"),
	DEBUG_SEGFAULT("DEBUG SEGFAULT"),
	RPUSH("RPUSH"),
	LRANGE("LRANGE"),
	HDEL("HDEL"),
	PFMERGE("PFMERGE"),
	SELECT("SELECT"),
	BITPOS("BITPOS"),
	PUBSUB("PUBSUB"),
	LINSERT("LINSERT"),
	PFADD("PFADD"),
	BRPOPLPUSH("BRPOPLPUSH"),
	LTRIM("LTRIM"),
	MSET("MSET"),
	RESTORE("RESTORE"),
	SINTER("SINTER"),
	BRPOP("BRPOP"),
	WATCH("WATCH"),
	CLIENT_GETNAME("CLIENT GETNAME"),
	CONFIG_GET("CONFIG GET"),
	SMEMBERS("SMEMBERS"),
	SETNX("SETNX"),
	ZREVRANGEBYSCORE("ZREVRANGEBYSCORE"),
	INCRBYFLOAT("INCRBYFLOAT"),
	SPOP("SPOP"),
	HLEN("HLEN"),
	SLAVEOF("SLAVEOF"),
	PSETEX("PSETEX"),
	EXPIRE("EXPIRE"),
	DECRBY("DECRBY"),
	MSETNX("MSETNX"),
	PING("PING"),
	DISCARD("DISCARD"),
	ZUNIONSTORE("ZUNIONSTORE"),
	EVAL("EVAL"),
	ZRANGEBYLEX("ZRANGEBYLEX"),
	MIGRATE("MIGRATE"),
	FLUSHDB("FLUSHDB"),
	LLEN("LLEN"),
	SHUTDOWN("SHUTDOWN"),
	PTTL("PTTL"),
	HGETALL("HGETALL"),
	CONFIG_REWRITE("CONFIG REWRITE"),
	ZREM("ZREM"),
	BITOP("BITOP"),
	SCRIPT_KILL("SCRIPT KILL"),
	SUNION("SUNION"),
	RENAME("RENAME"),
	RPOPLPUSH("RPOPLPUSH"),
	DBSIZE("DBSIZE"),
	APPEND("APPEND"),
	DEL("DEL"),
	RANDOMKEY("RANDOMKEY"),
	CLIENT_KILL("CLIENT KILL"),
	HGET("HGET"),
	SREM("SREM"),
	SUBSCRIBE("SUBSCRIBE"),
	ZSCAN("ZSCAN"),
	MULTI("MULTI"),
	HSET("HSET"),
	RPUSHX("RPUSHX"),
	SISMEMBER("SISMEMBER"),
	SETBIT("SETBIT"),
	QUIT("QUIT"),
	TIME("TIME"),
	PUNSUBSCRIBE("PUNSUBSCRIBE"),
	SLOWLOG("SLOWLOG"),
	ZINCRBY("ZINCRBY"),
	SCARD("SCARD"),
	AUTH("AUTH"),
	OBJECT("OBJECT"),
	SDIFFSTORE("SDIFFSTORE"),
	LREM("LREM"),
	SCAN("SCAN"),
	SCRIPT_LOAD("SCRIPT LOAD"),
	DUMP("DUMP"),
	UNSUBSCRIBE("UNSUBSCRIBE"),
	ZINTERSTORE("ZINTERSTORE"),
	ZRANGEBYSCORE("ZRANGEBYSCORE"),
	MGET("MGET"),
	EXPIREAT("EXPIREAT"),
	ZREMRANGEBYSCORE("ZREMRANGEBYSCORE"),
	ZRANK("ZRANK"),
	EXISTS("EXISTS"),
	ZRANGE("ZRANGE"),
	GETRANGE("GETRANGE"),
	SETEX("SETEX"),
	ZCARD("ZCARD"),
	CONFIG_RESETSTAT("CONFIG RESETSTAT"),
	ZREVRANGE("ZREVRANGE"),
	BLPOP("BLPOP"),
	ZADD("ZADD"),
	SDIFF("SDIFF"),
	HINCRBYFLOAT("HINCRBYFLOAT"),
	HEXISTS("HEXISTS"),
	BGREWRITEAOF("BGREWRITEAOF"),
	SYNC("SYNC"),
	ZLEXCOUNT("ZLEXCOUNT"),
	GETSET("GETSET"),
	FLUSHALL("FLUSHALL"),
	RENAMENX("RENAMENX"),
	SUNIONSTORE("SUNIONSTORE"),
	HSCAN("HSCAN"),
	SORT("SORT"),
	ZSCORE("ZSCORE"),
	SET("SET"),
	SAVE("SAVE"),
	EXEC("EXEC"),
	HINCRBY("HINCRBY"),
	HKEYS("HKEYS"),
	SRANDMEMBER("SRANDMEMBER"),
	SSCAN("SSCAN"),
	LINDEX("LINDEX"),
	INCRBY("INCRBY"),
	INFO("INFO"),
	ZREMRANGEBYRANK("ZREMRANGEBYRANK"),
	ZCOUNT("ZCOUNT"),
	SETRANGE("SETRANGE"),
	LPOP("LPOP"),
	PFCOUNT("PFCOUNT"),
	PSUBSCRIBE("PSUBSCRIBE"),
	ECHO("ECHO"),
	BGSAVE("BGSAVE"),
	EVALSHA("EVALSHA"),
	LPUSH("LPUSH"),
	PERSIST("PERSIST"),
	PEXPIRE("PEXPIRE"),
	CLIENT_PAUSE("CLIENT PAUSE"),
	RPOP("RPOP"),
	MOVE("MOVE"),
	LPUSHX("LPUSHX"),
	DECR("DECR"),
	HVALS("HVALS"),
	CONFIG_SET("CONFIG SET"),
	KEYS("KEYS"),
	HSETNX("HSETNX"),
	GETBIT("GETBIT"),
	CLIENT_LIST("CLIENT LIST"),
	CLIENT_SETNAME("CLIENT SETNAME"),
	PUBLISH("PUBLISH"),
	ZREMRANGEBYLEX("ZREMRANGEBYLEX"),
	SCRIPT_FLUSH("SCRIPT FLUSH"),
	DEBUG_OBJECT("DEBUG OBJECT"),
	;

	private final String command;

	RedisCommand(String command)
	{
		this.command = command;
	}

	public String getCommand()
	{
		return command;
	}
}
