/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.java.redis;

import io.vertx.java.redis.RedisCommand;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonElement;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;

abstract class AbstractRedisClient {
    final EventBus eventBus;
    final String redisAddress;

    AbstractRedisClient(EventBus eventBus, String redisAddress) {
        this.eventBus = eventBus;
        this.redisAddress = redisAddress;
    }

    public final void deployModule(Container container) {
        this.deployModule(container, "localhost", 6379, "UTF-8", false, null, 0, 1, null);
    }

    public final void deployModule(Container container, AsyncResultHandler<String> handler) {
        this.deployModule(container, "localhost", 6379, "UTF-8", false, null, 0, 1, handler);
    }

    public final void deployModule(Container container, String hostname, int port) {
        this.deployModule(container, hostname, port, "UTF-8", false, null, 0, 1, null);
    }

    public final void deployModule(Container container, String hostname, int port, AsyncResultHandler<String> handler) {
        this.deployModule(container, hostname, port, "UTF-8", false, null, 0, 1, handler);
    }

    public final void deployModule(Container container, String hostname, int port, int instances) {
        this.deployModule(container, hostname, port, "UTF-8", false, null, 0, instances, null);
    }

    public final void deployModule(Container container, String hostname, int port, int instances, AsyncResultHandler<String> handler) {
        this.deployModule(container, hostname, port, "UTF-8", false, null, 0, instances, handler);
    }

    private static AsyncResult<String> createAsyncResult(final boolean succeed, final String result, final Throwable cause) {
        return new AsyncResult<String>(){

            public String result() {
                return result;
            }

            public Throwable cause() {
                return cause;
            }

            public boolean succeeded() {
                return succeed;
            }

            public boolean failed() {
                return !succeed;
            }
        };
    }

    public final void deployModule(Container container, JsonObject config, AsyncResultHandler<String> handler) {
        String mod = "io.vertx~mod-redis~1.1.5";
        int instances = config.getInteger("instances", 1);
        if (handler != null) {
            container.deployModule(mod, config, instances, handler);
        } else {
            container.deployModule(mod, config, instances);
        }
    }

    public final void deployModule(Container container, String hostname, int port, String encoding, boolean binary, String auth, int select, int instances, AsyncResultHandler<String> handler) {
        JsonObject config = new JsonObject().putString("host", hostname).putNumber("port", (Number)port).putString("address", this.redisAddress).putString("encoding", encoding).putBoolean("binary", Boolean.valueOf(binary)).putString("auth", auth).putNumber("select", (Number)select).putNumber("instances", (Number)instances);
        this.deployModule(container, config, handler);
    }

    private static void serializeArg(JsonArray redisArgs, Object arg) {
        if (arg == null) {
            redisArgs.add(null);
        } else if (arg instanceof String) {
            redisArgs.addString((String)arg);
        } else if (arg instanceof Object[]) {
            for (Object o : (Object[])arg) {
                redisArgs.add(o);
            }
        } else if (arg instanceof JsonObject) {
            redisArgs.addObject((JsonObject)arg);
        } else if (arg instanceof JsonArray) {
            redisArgs.addArray((JsonArray)arg);
        } else if (arg instanceof JsonElement) {
            redisArgs.addElement((JsonElement)arg);
        } else if (arg instanceof Number) {
            redisArgs.addNumber((Number)arg);
        } else if (arg instanceof Boolean) {
            redisArgs.addBoolean((Boolean)arg);
        } else if (arg instanceof byte[]) {
            redisArgs.addBinary((byte[])arg);
        } else {
            throw new RuntimeException("Unsupported type: " + arg.getClass().getName());
        }
    }

    final void send(RedisCommand command, Object ... args) {
        JsonObject json = new JsonObject();
        JsonArray redisArgs = new JsonArray();
        int totalArgs = 0;
        boolean expectResult = false;
        Handler messageHandler = null;
        if (args != null && args.length > 0) {
            Object last = args[args.length - 1];
            totalArgs = args.length;
            if (last instanceof Handler) {
                expectResult = true;
                --totalArgs;
                messageHandler = (Handler)last;
            }
        }
        json.putString("command", command.getCommand());
        switch (command) {
            case MSET: 
            case MSETNX: 
            case HMSET: 
            case ZADD: {
                if (totalArgs != 2 || !(args[1] instanceof JsonObject)) break;
                AbstractRedisClient.serializeArg(redisArgs, args[0]);
                JsonObject hash = (JsonObject)args[1];
                for (String key : hash.getFieldNames()) {
                    AbstractRedisClient.serializeArg(redisArgs, key);
                    AbstractRedisClient.serializeArg(redisArgs, hash.getField(key));
                }
                totalArgs = 0;
            }
        }
        for (int i = 0; i < totalArgs; ++i) {
            AbstractRedisClient.serializeArg(redisArgs, args[i]);
        }
        json.putArray("args", redisArgs);
        if (expectResult) {
            this.eventBus.send(this.redisAddress, json, messageHandler);
        } else {
            this.eventBus.send(this.redisAddress, json);
        }
    }
}

