/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.testtools;

import org.vertx.java.core.buffer.Buffer;

public class TestUtils {
    public static Buffer generateRandomBuffer(int length) {
        return TestUtils.generateRandomBuffer(length, false, (byte)0);
    }

    public static byte[] generateRandomByteArray(int length) {
        return TestUtils.generateRandomByteArray(length, false, (byte)0);
    }

    public static byte[] generateRandomByteArray(int length, boolean avoid, byte avoidByte) {
        byte[] line = new byte[length];
        for (int i = 0; i < length; ++i) {
            byte rand;
            do {
                rand = (byte)((int)(Math.random() * 255.0) - 128);
            } while (avoid && rand == avoidByte);
            line[i] = rand;
        }
        return line;
    }

    public static Buffer generateRandomBuffer(int length, boolean avoid, byte avoidByte) {
        byte[] line = TestUtils.generateRandomByteArray(length, avoid, avoidByte);
        return new Buffer(line);
    }

    public static String randomUnicodeString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c;
            while ((c = (char)(65535.0 * Math.random())) >= '\ufffe' && c <= '\uffff' || c >= '\ud800' && c <= '\udfff') {
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String randomAlphaString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = (char)(65.0 + 25.0 * Math.random());
            builder.append(c);
        }
        return builder.toString();
    }

    public static boolean buffersEqual(Buffer b1, Buffer b2) {
        if (b1.length() != b2.length()) {
            return false;
        }
        for (int i = 0; i < b1.length(); ++i) {
            if (b1.getByte(i) == b2.getByte(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean byteArraysEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private TestUtils() {
    }
}

