/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.testtools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.internal.ArrayComparisonFailure;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class VertxAssert {
    private static Vertx jVertx;

    public static void initialize(Vertx vertx) {
        jVertx = vertx;
    }

    public static void handleThrowable(Throwable t) {
        if (jVertx == null) {
            throw new IllegalStateException("Please initialise VertxAssert before use");
        }
        JsonObject failure = new JsonObject().putString("type", "failure");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(t);
            oos.flush();
            byte[] bytes = baos.toByteArray();
            failure.putBinary("failure", bytes);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to serialise error: " + ex.getMessage(), ex);
        }
        finally {
            jVertx.eventBus().send("vertx.testframework.handler", failure);
        }
    }

    public static void testComplete() {
        jVertx.eventBus().send("vertx.testframework.handler", new JsonObject().putString("type", "done"));
    }

    public static void assertTrue(String message, boolean condition) {
        try {
            Assert.assertTrue((String)message, (boolean)condition);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertFalse(boolean condition) {
        try {
            Assert.assertFalse((boolean)condition);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(String message, char[] expecteds, char[] actuals) throws ArrayComparisonFailure {
        try {
            Assert.assertArrayEquals((String)message, (char[])expecteds, (char[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertSame(String message, Object expected, Object actual) {
        try {
            Assert.assertSame((String)message, (Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertEquals(long expected, long actual) {
        try {
            Assert.assertEquals((long)expected, (long)actual);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertNull(Object object) {
        try {
            Assert.assertNull((Object)object);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertFalse(String message, boolean condition) {
        try {
            Assert.assertFalse((String)message, (boolean)condition);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void fail(String message) {
        try {
            Assert.fail((String)message);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertNull(String message, Object object) {
        try {
            Assert.assertNull((String)message, (Object)object);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(String message, float[] expecteds, float[] actuals, float delta) throws ArrayComparisonFailure {
        try {
            Assert.assertArrayEquals((String)message, (float[])expecteds, (float[])actuals, (float)delta);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    @Deprecated
    public static void assertEquals(String message, double expected, double actual) {
        try {
            Assert.assertEquals((String)message, (double)expected, (double)actual);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(String message, double[] expecteds, double[] actuals, double delta) throws ArrayComparisonFailure {
        try {
            Assert.assertArrayEquals((String)message, (double[])expecteds, (double[])actuals, (double)delta);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(String message, Object[] expecteds, Object[] actuals) throws ArrayComparisonFailure {
        try {
            Assert.assertArrayEquals((String)message, (Object[])expecteds, (Object[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(String message, short[] expecteds, short[] actuals) throws ArrayComparisonFailure {
        try {
            Assert.assertArrayEquals((String)message, (short[])expecteds, (short[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(short[] expecteds, short[] actuals) {
        try {
            Assert.assertArrayEquals((short[])expecteds, (short[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(long[] expecteds, long[] actuals) {
        try {
            Assert.assertArrayEquals((long[])expecteds, (long[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertNotNull(Object object) {
        try {
            Assert.assertNotNull((Object)object);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        try {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertTrue(boolean condition) {
        try {
            Assert.assertTrue((boolean)condition);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(Object[] expecteds, Object[] actuals) {
        try {
            Assert.assertArrayEquals((Object[])expecteds, (Object[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertNotNull(String message, Object object) {
        try {
            Assert.assertNotNull((String)message, (Object)object);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        try {
            Assert.assertEquals((String)message, (double)expected, (double)actual, (double)delta);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void fail() {
        try {
            Assert.fail();
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertSame(Object expected, Object actual) {
        try {
            Assert.assertSame((Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertEquals(String message, long expected, long actual) {
        try {
            Assert.assertEquals((String)message, (long)expected, (long)actual);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(String message, byte[] expecteds, byte[] actuals) throws ArrayComparisonFailure {
        try {
            Assert.assertArrayEquals((String)message, (byte[])expecteds, (byte[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(String message, long[] expecteds, long[] actuals) throws ArrayComparisonFailure {
        try {
            Assert.assertArrayEquals((String)message, (long[])expecteds, (long[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        try {
            Assert.assertEquals((double)expected, (double)actual, (double)delta);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static <T> void assertThat(T actual, Matcher<T> matcher) {
        try {
            Assert.assertThat(actual, matcher);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    @Deprecated
    public static void assertEquals(String message, Object[] expecteds, Object[] actuals) {
        try {
            Assert.assertEquals((String)message, (Object[])expecteds, (Object[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    @Deprecated
    public static void assertEquals(Object[] expecteds, Object[] actuals) {
        try {
            Assert.assertEquals((Object[])expecteds, (Object[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertNotSame(String message, Object unexpected, Object actual) {
        try {
            Assert.assertNotSame((String)message, (Object)unexpected, (Object)actual);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static <T> void assertThat(String reason, T actual, Matcher<T> matcher) {
        try {
            Assert.assertThat((String)reason, actual, matcher);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(float[] expecteds, float[] actuals, float delta) {
        try {
            Assert.assertArrayEquals((float[])expecteds, (float[])actuals, (float)delta);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertNotSame(Object unexpected, Object actual) {
        try {
            Assert.assertNotSame((Object)unexpected, (Object)actual);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(byte[] expecteds, byte[] actuals) {
        try {
            Assert.assertArrayEquals((byte[])expecteds, (byte[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(char[] expecteds, char[] actuals) {
        try {
            Assert.assertArrayEquals((char[])expecteds, (char[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(double[] expecteds, double[] actuals, double delta) {
        try {
            Assert.assertArrayEquals((double[])expecteds, (double[])actuals, (double)delta);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(int[] expecteds, int[] actuals) {
        try {
            Assert.assertArrayEquals((int[])expecteds, (int[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    @Deprecated
    public static void assertEquals(double expected, double actual) {
        try {
            Assert.assertEquals((double)expected, (double)actual);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }

    public static void assertArrayEquals(String message, int[] expecteds, int[] actuals) throws ArrayComparisonFailure {
        try {
            Assert.assertArrayEquals((String)message, (int[])expecteds, (int[])actuals);
        }
        catch (AssertionError e) {
            VertxAssert.handleThrowable((Throwable)((Object)e));
        }
    }
}

