/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.amqpbridge;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.amqpbridge.AmqpBridgeOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.eventbus.MessageConsumer;
import io.vertx.reactivex.core.eventbus.MessageProducer;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.impl.AsyncResultSingle;

@RxGen(value=io.vertx.amqpbridge.AmqpBridge.class)
public class AmqpBridge {
    public static final TypeArg<AmqpBridge> __TYPE_ARG = new TypeArg(obj -> new AmqpBridge((io.vertx.amqpbridge.AmqpBridge)obj), AmqpBridge::getDelegate);
    private final io.vertx.amqpbridge.AmqpBridge delegate;

    public AmqpBridge(io.vertx.amqpbridge.AmqpBridge delegate) {
        this.delegate = delegate;
    }

    public io.vertx.amqpbridge.AmqpBridge getDelegate() {
        return this.delegate;
    }

    public static AmqpBridge create(Vertx vertx) {
        AmqpBridge ret = AmqpBridge.newInstance(io.vertx.amqpbridge.AmqpBridge.create(vertx.getDelegate()));
        return ret;
    }

    public static AmqpBridge create(Vertx vertx, AmqpBridgeOptions options) {
        AmqpBridge ret = AmqpBridge.newInstance(io.vertx.amqpbridge.AmqpBridge.create(vertx.getDelegate(), options));
        return ret;
    }

    public void start(String hostname, int port, String username, String password, final Handler<AsyncResult<AmqpBridge>> resultHandler) {
        this.delegate.start(hostname, port, username, password, new Handler<AsyncResult<io.vertx.amqpbridge.AmqpBridge>>(){

            public void handle(AsyncResult<io.vertx.amqpbridge.AmqpBridge> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)AmqpBridge.newInstance((io.vertx.amqpbridge.AmqpBridge)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<AmqpBridge> rxStart(String hostname, int port, String username, String password) {
        return new AsyncResultSingle(handler -> this.start(hostname, port, username, password, (Handler<AsyncResult<AmqpBridge>>)handler));
    }

    public void start(String hostname, int port, final Handler<AsyncResult<AmqpBridge>> resultHandler) {
        this.delegate.start(hostname, port, new Handler<AsyncResult<io.vertx.amqpbridge.AmqpBridge>>(){

            public void handle(AsyncResult<io.vertx.amqpbridge.AmqpBridge> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)AmqpBridge.newInstance((io.vertx.amqpbridge.AmqpBridge)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<AmqpBridge> rxStart(String hostname, int port) {
        return new AsyncResultSingle(handler -> this.start(hostname, port, (Handler<AsyncResult<AmqpBridge>>)handler));
    }

    public <T> MessageConsumer<T> createConsumer(String amqpAddress) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.createConsumer(amqpAddress), (TypeArg)TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> createProducer(String amqpAddress) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.createProducer(amqpAddress), (TypeArg)TypeArg.unknown());
        return ret;
    }

    public void close(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.close(resultHandler);
    }

    public Completable rxClose() {
        return new AsyncResultCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    public void endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
    }

    public static AmqpBridge newInstance(io.vertx.amqpbridge.AmqpBridge arg) {
        return arg != null ? new AmqpBridge(arg) : null;
    }
}

