/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqpbridge.impl;

import io.vertx.amqpbridge.impl.AmqpBridgeImpl;
import io.vertx.amqpbridge.impl.AmqpMessageImpl;
import io.vertx.amqpbridge.impl.MessageTranslatorImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.impl.BodyReadStream;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.streams.ReadStream;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonReceiver;
import java.util.ArrayDeque;
import java.util.Queue;

public class AmqpConsumerImpl
implements MessageConsumer<JsonObject> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpConsumerImpl.class);
    private final AmqpBridgeImpl bridge;
    private final ProtonReceiver receiver;
    private final String amqpAddress;
    private final MessageTranslatorImpl translator = new MessageTranslatorImpl();
    private final Queue<AmqpMessageImpl> buffered = new ArrayDeque<AmqpMessageImpl>();
    private Handler<Message<JsonObject>> handler;
    private long demand = Long.MAX_VALUE;
    private boolean closed;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;
    private boolean initialCreditGiven;
    private int initialCredit = 1000;

    public AmqpConsumerImpl(AmqpBridgeImpl bridge, ProtonConnection connection, String amqpAddress) {
        if (!bridge.onContextEventLoop()) {
            throw new IllegalStateException("Consumer creation was not executed on the bridge context thread");
        }
        this.bridge = bridge;
        this.amqpAddress = amqpAddress;
        this.receiver = connection.createReceiver(amqpAddress);
        this.receiver.closeHandler(res -> {
            Handler<Void> endh = null;
            Handler<Throwable> exh = null;
            boolean closeReceiver = false;
            AmqpConsumerImpl amqpConsumerImpl = this;
            synchronized (amqpConsumerImpl) {
                if (!this.closed && this.endHandler != null) {
                    endh = this.endHandler;
                } else if (!this.closed && this.exceptionHandler != null) {
                    exh = this.exceptionHandler;
                }
                if (!this.closed) {
                    this.closed = true;
                    closeReceiver = true;
                }
            }
            if (endh != null) {
                endh.handle(null);
            } else if (exh != null) {
                if (res.succeeded()) {
                    exh.handle((Object)new VertxException("Consumer closed remotely"));
                } else {
                    exh.handle((Object)new VertxException("Consumer closed remotely with error", res.cause()));
                }
            } else if (res.succeeded()) {
                LOG.warn((Object)("Consumer for address " + amqpAddress + " unexpectedly closed remotely"));
            } else {
                LOG.warn((Object)("Consumer for address " + amqpAddress + " unexpectedly closed remotely with error"), res.cause());
            }
            if (closeReceiver) {
                this.receiver.close();
            }
        });
        this.receiver.handler((delivery, protonMessage) -> {
            JsonObject body = this.translator.convertToJsonObject(protonMessage);
            AmqpMessageImpl vertxMessage = new AmqpMessageImpl(body, this.bridge, protonMessage, delivery, amqpAddress, protonMessage.getReplyTo());
            this.handleMessage(vertxMessage);
        });
        this.receiver.setAutoAccept(false);
        this.receiver.setPrefetch(0);
        this.receiver.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(AmqpMessageImpl vertxMessage) {
        Handler<Message<JsonObject>> h = null;
        boolean schedule = false;
        AmqpConsumerImpl amqpConsumerImpl = this;
        synchronized (amqpConsumerImpl) {
            if (this.handler != null && this.demand > 0L && this.buffered.isEmpty()) {
                h = this.handler;
                if (this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
            } else if (this.handler != null && this.demand > 0L) {
                this.buffered.add(vertxMessage);
                vertxMessage = this.buffered.poll();
                h = this.handler;
                if (this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                schedule = true;
            } else {
                this.buffered.add(vertxMessage);
            }
        }
        if (h != null) {
            this.deliverMessageToHandler(vertxMessage, h);
        }
        if (schedule) {
            this.scheduleBufferedMessageDelivery();
        }
    }

    private void deliverMessageToHandler(AmqpMessageImpl vertxMessage, Handler<Message<JsonObject>> h) {
        h.handle((Object)vertxMessage);
        vertxMessage.accept();
        this.receiver.flow(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleBufferedMessageDelivery() {
        boolean schedule;
        AmqpConsumerImpl amqpConsumerImpl = this;
        synchronized (amqpConsumerImpl) {
            schedule = !this.buffered.isEmpty() && this.demand > 0L;
        }
        if (schedule) {
            this.bridge.runOnContext(false, (Handler<Void>)((Handler)v -> {
                Handler<Message<JsonObject>> h = null;
                AmqpMessageImpl message = null;
                AmqpConsumerImpl amqpConsumerImpl = this;
                synchronized (amqpConsumerImpl) {
                    h = this.handler;
                    if (h != null && this.demand > 0L) {
                        if (this.demand != Long.MAX_VALUE) {
                            --this.demand;
                        }
                        message = this.buffered.poll();
                    }
                }
                if (message != null) {
                    this.deliverMessageToHandler(message, h);
                    this.scheduleBufferedMessageDelivery();
                }
            }));
        }
    }

    public synchronized MessageConsumer<JsonObject> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer<JsonObject> handler(Handler<Message<JsonObject>> handler) {
        int creditToFlow = 0;
        boolean schedule = false;
        AmqpConsumerImpl amqpConsumerImpl = this;
        synchronized (amqpConsumerImpl) {
            this.handler = handler;
            if (handler != null) {
                schedule = true;
                if (!this.initialCreditGiven) {
                    this.initialCreditGiven = true;
                    creditToFlow = this.initialCredit;
                }
            }
        }
        if (creditToFlow > 0) {
            int c = creditToFlow;
            this.bridge.runOnContext(true, (Handler<Void>)((Handler)v -> this.receiver.flow(c)));
        }
        if (schedule) {
            this.scheduleBufferedMessageDelivery();
        }
        return this;
    }

    public synchronized MessageConsumer<JsonObject> pause() {
        this.demand = 0L;
        return this;
    }

    public synchronized MessageConsumer<JsonObject> fetch(long amount) {
        if (amount > 0L) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
            this.scheduleBufferedMessageDelivery();
        }
        return this;
    }

    public synchronized MessageConsumer<JsonObject> resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    public synchronized MessageConsumer<JsonObject> endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    public ReadStream<JsonObject> bodyStream() {
        return new BodyReadStream((ReadStream)this);
    }

    public synchronized boolean isRegistered() {
        return this.handler != null;
    }

    public String address() {
        return this.amqpAddress;
    }

    public synchronized MessageConsumer<JsonObject> setMaxBufferedMessages(int maxBufferedMessages) {
        if (!this.initialCreditGiven) {
            this.initialCredit = maxBufferedMessages;
        }
        return this;
    }

    public synchronized int getMaxBufferedMessages() {
        return this.initialCredit;
    }

    public void completionHandler(Handler<AsyncResult<Void>> completionHandler) {
        throw new UnsupportedOperationException("Registration completion handler is not supported by this consumer");
    }

    public synchronized void unregister() {
        this.unregister(null);
    }

    public synchronized void unregister(Handler<AsyncResult<Void>> completionHandler) {
        this.handler = null;
        this.closed = true;
        this.bridge.runOnContext(true, (Handler<Void>)((Handler)v -> {
            if (completionHandler != null) {
                this.receiver.closeHandler(result -> {
                    if (result.succeeded()) {
                        completionHandler.handle((Object)Future.succeededFuture());
                    } else {
                        completionHandler.handle((Object)Future.failedFuture((Throwable)result.cause()));
                    }
                });
            } else {
                this.receiver.closeHandler(null);
            }
            this.receiver.close();
        }));
    }
}

