/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqpbridge.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class MessageTranslatorImpl {
    private static final AmqpValue EMPTY_BODY_SECTION = new AmqpValue(null);

    public JsonObject convertToJsonObject(Message protonMessage) throws IllegalArgumentException {
        MessageAnnotations msgAnn;
        ApplicationProperties appProps;
        Header header;
        JsonObject jsonObject = new JsonObject();
        Section body = protonMessage.getBody();
        if (body instanceof AmqpValue) {
            Object value = this.translateToJsonCompatible(((AmqpValue)body).getValue());
            jsonObject.put("body", value);
            jsonObject.put("body_type", "value");
        } else if (body instanceof Data) {
            Binary bin = ((Data)body).getValue();
            byte[] bytes = new byte[bin.getLength()];
            System.arraycopy(bin.getArray(), bin.getArrayOffset(), bytes, 0, bin.getLength());
            jsonObject.put("body", bytes);
            jsonObject.put("body_type", "data");
        } else if (body instanceof AmqpSequence) {
            JsonArray jsonSequence = (JsonArray)this.translateToJsonCompatible(((AmqpSequence)body).getValue());
            jsonObject.put("body", jsonSequence);
            jsonObject.put("body_type", "sequence");
        }
        Properties props = protonMessage.getProperties();
        if (props != null) {
            JsonObject jsonProps = this.createJsonProperties(props);
            jsonObject.put("properties", jsonProps);
        }
        if ((header = protonMessage.getHeader()) != null) {
            JsonObject jsonHeader = this.createJsonHeader(header);
            jsonObject.put("header", jsonHeader);
        }
        if ((appProps = protonMessage.getApplicationProperties()) != null && appProps.getValue() != null) {
            JsonObject jsonAppProps = this.createJsonApplicationProperties(appProps.getValue());
            jsonObject.put("application_properties", jsonAppProps);
        }
        if ((msgAnn = protonMessage.getMessageAnnotations()) != null && msgAnn.getValue() != null) {
            JsonObject jsonMsgAnn = this.createJsonMessageAnnotations(msgAnn.getValue());
            jsonObject.put("message_annotations", jsonMsgAnn);
        }
        return jsonObject;
    }

    private JsonObject createJsonHeader(Header protonHeader) {
        JsonObject jsonHeader = new JsonObject();
        if (protonHeader.getDurable() != null) {
            jsonHeader.put("durable", protonHeader.getDurable());
        }
        if (protonHeader.getPriority() != null) {
            jsonHeader.put("priority", (Object)protonHeader.getPriority().shortValue());
        }
        if (protonHeader.getTtl() != null) {
            jsonHeader.put("ttl", Long.valueOf(protonHeader.getTtl().longValue()));
        }
        if (protonHeader.getFirstAcquirer() != null) {
            jsonHeader.put("first_acquirer", protonHeader.getFirstAcquirer());
        }
        if (protonHeader.getDeliveryCount() != null) {
            jsonHeader.put("delivery_count", Long.valueOf(protonHeader.getDeliveryCount().longValue()));
        }
        return jsonHeader;
    }

    private JsonObject createJsonMessageAnnotations(Map<Symbol, Object> msgAnn) {
        JsonObject jsonMsgAnn = new JsonObject();
        for (Map.Entry<Symbol, Object> entry : msgAnn.entrySet()) {
            Symbol key = entry.getKey();
            Object value = this.translateToJsonCompatible(entry.getValue());
            jsonMsgAnn.put(key.toString(), value);
        }
        return jsonMsgAnn;
    }

    private JsonObject createJsonProperties(Properties protonProps) {
        JsonObject jsonProps = new JsonObject();
        if (protonProps.getTo() != null) {
            jsonProps.put("to", protonProps.getTo());
        }
        if (protonProps.getReplyTo() != null) {
            jsonProps.put("reply_to", protonProps.getReplyTo());
        }
        if (protonProps.getMessageId() != null) {
            jsonProps.put("message_id", protonProps.getMessageId().toString());
        }
        if (protonProps.getCorrelationId() != null) {
            jsonProps.put("correlation_id", protonProps.getCorrelationId().toString());
        }
        if (protonProps.getSubject() != null) {
            jsonProps.put("subject", protonProps.getSubject());
        }
        if (protonProps.getGroupId() != null) {
            jsonProps.put("group_id", protonProps.getGroupId());
        }
        if (protonProps.getGroupSequence() != null) {
            jsonProps.put("group_sequence", Long.valueOf(protonProps.getGroupSequence().longValue()));
        }
        if (protonProps.getReplyToGroupId() != null) {
            jsonProps.put("reply_to_group_id", protonProps.getReplyToGroupId());
        }
        if (protonProps.getContentType() != null) {
            jsonProps.put("content_type", protonProps.getContentType().toString());
        }
        if (protonProps.getContentEncoding() != null) {
            jsonProps.put("content_encoding", protonProps.getContentEncoding().toString());
        }
        if (protonProps.getCreationTime() != null) {
            jsonProps.put("creation_time", Long.valueOf(protonProps.getCreationTime().getTime()));
        }
        if (protonProps.getAbsoluteExpiryTime() != null) {
            jsonProps.put("absolute_expiry_time", Long.valueOf(protonProps.getAbsoluteExpiryTime().getTime()));
        }
        if (protonProps.getUserId() != null) {
            Binary bin = protonProps.getUserId();
            String userId = new String(bin.getArray(), bin.getArrayOffset(), bin.getLength(), StandardCharsets.UTF_8);
            jsonProps.put("user_id", userId);
        }
        return jsonProps;
    }

    private JsonObject createJsonApplicationProperties(Map<String, Object> appProps) {
        JsonObject jsonAppProps = new JsonObject();
        for (Map.Entry<String, Object> entry : appProps.entrySet()) {
            String key = entry.getKey();
            Object value = this.translateToJsonCompatible(entry.getValue());
            jsonAppProps.put(key, value);
        }
        return jsonAppProps;
    }

    private Object translateToJsonCompatible(Object value) {
        if (value instanceof Map) {
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object val = this.translateToJsonCompatible(entry.getValue());
                jsonObject.put(key, val);
            }
            value = jsonObject;
        } else if (value instanceof List) {
            JsonArray jsonArray = new JsonArray();
            for (Object entry : (List)value) {
                Object val = this.translateToJsonCompatible(entry);
                jsonArray.add(val);
            }
            value = jsonArray;
        } else if (value instanceof Binary) {
            Binary bin = (Binary)value;
            byte[] bytes = new byte[bin.getLength()];
            System.arraycopy(bin.getArray(), bin.getArrayOffset(), bytes, 0, bin.getLength());
            value = bytes;
        } else if (value instanceof Date) {
            value = ((Date)value).getTime();
        }
        return value;
    }

    public Message convertToAmqpMessage(JsonObject jsonObject) throws IllegalArgumentException {
        Message protonMessage = Message.Factory.create();
        if (jsonObject.containsKey("body")) {
            String bodyType = jsonObject.getString("body_type");
            if (bodyType == null || "value".equals(bodyType)) {
                Object value = this.translateToAmqpCompatible(jsonObject.getValue("body"));
                protonMessage.setBody((Section)new AmqpValue(value));
            } else if ("data".equals(bodyType)) {
                byte[] bytes = jsonObject.getBinary("body");
                protonMessage.setBody((Section)new Data(new Binary(bytes)));
            } else if ("sequence".equals(bodyType)) {
                JsonArray jsonSequence = jsonObject.getJsonArray("body");
                List list = (List)this.translateToAmqpCompatible(jsonSequence);
                protonMessage.setBody((Section)new AmqpSequence(list));
            }
        } else {
            protonMessage.setBody((Section)EMPTY_BODY_SECTION);
        }
        if (jsonObject.containsKey("properties")) {
            Properties props = this.createAmqpProperties(jsonObject.getJsonObject("properties"));
            protonMessage.setProperties(props);
        }
        if (jsonObject.containsKey("header")) {
            Header header = this.createAmqpHeader(jsonObject.getJsonObject("header"));
            protonMessage.setHeader(header);
        }
        if (jsonObject.containsKey("application_properties")) {
            ApplicationProperties appProps = this.createAmqpApplicationProperties(jsonObject.getJsonObject("application_properties"));
            protonMessage.setApplicationProperties(appProps);
        }
        if (jsonObject.containsKey("message_annotations")) {
            MessageAnnotations msgAnn = this.createAmqpMessageAnnotations(jsonObject.getJsonObject("message_annotations"));
            protonMessage.setMessageAnnotations(msgAnn);
        }
        return protonMessage;
    }

    private Header createAmqpHeader(JsonObject jsonHeader) {
        Header protonHeader = new Header();
        if (jsonHeader.containsKey("durable")) {
            protonHeader.setDurable(jsonHeader.getBoolean("durable"));
        }
        if (jsonHeader.containsKey("priority")) {
            int priority = jsonHeader.getInteger("priority");
            protonHeader.setPriority(UnsignedByte.valueOf((byte)((byte)priority)));
        }
        if (jsonHeader.containsKey("ttl")) {
            Long ttl = jsonHeader.getLong("ttl");
            protonHeader.setTtl(UnsignedInteger.valueOf((long)ttl));
        }
        if (jsonHeader.containsKey("first_acquirer")) {
            protonHeader.setFirstAcquirer(jsonHeader.getBoolean("first_acquirer"));
        }
        if (jsonHeader.containsKey("delivery_count")) {
            Long dc = jsonHeader.getLong("delivery_count");
            protonHeader.setDeliveryCount(UnsignedInteger.valueOf((long)dc));
        }
        return protonHeader;
    }

    private MessageAnnotations createAmqpMessageAnnotations(JsonObject jsonMsgAnn) {
        HashMap<Symbol, Object> ann = new HashMap<Symbol, Object>();
        MessageAnnotations protonMsgAnn = new MessageAnnotations(ann);
        Map underlying = jsonMsgAnn.getMap();
        for (Map.Entry entry : underlying.entrySet()) {
            Object value = this.translateToAmqpCompatible(entry.getValue());
            ann.put(Symbol.valueOf((String)((String)entry.getKey())), value);
        }
        return protonMsgAnn;
    }

    private ApplicationProperties createAmqpApplicationProperties(JsonObject jsonAppProps) {
        HashMap props = new HashMap();
        ApplicationProperties protonAppProps = new ApplicationProperties(props);
        Map underlying = jsonAppProps.getMap();
        for (Map.Entry entry : underlying.entrySet()) {
            Object value = this.translateToAmqpCompatible(entry.getValue());
            props.put(entry.getKey(), value);
        }
        return protonAppProps;
    }

    private Object translateToAmqpCompatible(Object value) {
        if (value instanceof JsonObject) {
            LinkedHashMap map = new LinkedHashMap();
            for (Map.Entry entry : (JsonObject)value) {
                Object val = this.translateToAmqpCompatible(entry.getValue());
                map.put(entry.getKey(), val);
            }
            value = map;
        } else if (value instanceof JsonArray) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object entry : (JsonArray)value) {
                Object val = this.translateToAmqpCompatible(entry);
                list.add(val);
            }
            value = list;
        }
        return value;
    }

    private Properties createAmqpProperties(JsonObject jsonProps) {
        Properties proptonProps = new Properties();
        if (jsonProps.containsKey("to")) {
            proptonProps.setTo(jsonProps.getString("to"));
        }
        if (jsonProps.containsKey("reply_to")) {
            proptonProps.setReplyTo(jsonProps.getString("reply_to"));
        }
        if (jsonProps.containsKey("message_id")) {
            proptonProps.setMessageId((Object)jsonProps.getString("message_id"));
        }
        if (jsonProps.containsKey("correlation_id")) {
            proptonProps.setCorrelationId((Object)jsonProps.getString("correlation_id"));
        }
        if (jsonProps.containsKey("subject")) {
            proptonProps.setSubject(jsonProps.getString("subject"));
        }
        if (jsonProps.containsKey("group_id")) {
            proptonProps.setGroupId(jsonProps.getString("group_id"));
        }
        if (jsonProps.containsKey("group_sequence")) {
            Long seq = jsonProps.getLong("group_sequence");
            proptonProps.setGroupSequence(UnsignedInteger.valueOf((long)seq));
        }
        if (jsonProps.containsKey("reply_to_group_id")) {
            proptonProps.setReplyToGroupId(jsonProps.getString("reply_to_group_id"));
        }
        if (jsonProps.containsKey("content_type")) {
            String contentType = jsonProps.getString("content_type");
            proptonProps.setContentType(Symbol.valueOf((String)contentType));
        }
        if (jsonProps.containsKey("content_encoding")) {
            String contentEncoding = jsonProps.getString("content_encoding");
            proptonProps.setContentEncoding(Symbol.valueOf((String)contentEncoding));
        }
        if (jsonProps.containsKey("creation_time")) {
            Long creationTime = jsonProps.getLong("creation_time");
            proptonProps.setCreationTime(new Date(creationTime));
        }
        if (jsonProps.containsKey("absolute_expiry_time")) {
            Long expiryTime = jsonProps.getLong("absolute_expiry_time");
            proptonProps.setAbsoluteExpiryTime(new Date(expiryTime));
        }
        if (jsonProps.containsKey("user_id")) {
            String userId = jsonProps.getString("user_id");
            proptonProps.setUserId(new Binary(userId.getBytes(StandardCharsets.UTF_8)));
        }
        return proptonProps;
    }
}

