/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqp.impl;

import io.vertx.amqp.AmqpMessage;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonHelper;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class AmqpMessageImpl
implements AmqpMessage {
    private final Message message;
    private final ProtonDelivery delivery;

    public AmqpMessageImpl(Message message, ProtonDelivery delivery) {
        this.message = message;
        this.delivery = delivery;
    }

    public AmqpMessageImpl(Message message) {
        this.message = message;
        this.delivery = null;
    }

    @Override
    public boolean isDurable() {
        return this.message.isDurable();
    }

    @Override
    public boolean isFirstAcquirer() {
        return this.message.isFirstAcquirer();
    }

    @Override
    public int priority() {
        return this.message.getPriority();
    }

    @Override
    public String id() {
        Object id = this.message.getMessageId();
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    @Override
    public String address() {
        return this.message.getAddress();
    }

    @Override
    public String replyTo() {
        return this.message.getReplyTo();
    }

    @Override
    public String correlationId() {
        Object id = this.message.getCorrelationId();
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    @Override
    public boolean isBodyNull() {
        return this.message.getBody() == null || this.getAmqpValue() == null;
    }

    private Object getAmqpValue() {
        if (this.message.getBody().getType() != Section.SectionType.AmqpValue) {
            throw new IllegalStateException("The body is not an AMQP Value");
        }
        return ((AmqpValue)this.message.getBody()).getValue();
    }

    @Override
    public boolean bodyAsBoolean() {
        return (Boolean)this.getAmqpValue();
    }

    @Override
    public byte bodyAsByte() {
        return (Byte)this.getAmqpValue();
    }

    @Override
    public short bodyAsShort() {
        return (Short)this.getAmqpValue();
    }

    @Override
    public int bodyAsInteger() {
        return (Integer)this.getAmqpValue();
    }

    @Override
    public long bodyAsLong() {
        return (Long)this.getAmqpValue();
    }

    @Override
    public float bodyAsFloat() {
        return ((Float)this.getAmqpValue()).floatValue();
    }

    @Override
    public double bodyAsDouble() {
        return (Double)this.getAmqpValue();
    }

    @Override
    public char bodyAsChar() {
        return ((Character)this.getAmqpValue()).charValue();
    }

    @Override
    public Instant bodyAsTimestamp() {
        Object value = this.getAmqpValue();
        if (!(value instanceof Date)) {
            throw new IllegalStateException("Expecting a Date object, got a " + value);
        }
        return ((Date)value).toInstant();
    }

    @Override
    public UUID bodyAsUUID() {
        return (UUID)this.getAmqpValue();
    }

    @Override
    public Buffer bodyAsBinary() {
        Section body = this.message.getBody();
        if (body.getType() != Section.SectionType.Data) {
            throw new IllegalStateException("The body is not of type 'data'");
        }
        byte[] bytes = ((Data)this.message.getBody()).getValue().getArray();
        return Buffer.buffer((byte[])bytes);
    }

    @Override
    public String bodyAsString() {
        return (String)this.getAmqpValue();
    }

    @Override
    public String bodyAsSymbol() {
        Object value = this.getAmqpValue();
        if (value instanceof Symbol) {
            return ((Symbol)value).toString();
        }
        throw new IllegalStateException("Expected a Symbol, got a " + value.getClass());
    }

    @Override
    public <T> List<T> bodyAsList() {
        Section body = this.message.getBody();
        if (body.getType() == Section.SectionType.AmqpSequence) {
            return ((AmqpSequence)this.message.getBody()).getValue();
        }
        Object value = this.getAmqpValue();
        if (value instanceof List) {
            return (List)value;
        }
        throw new IllegalStateException("Cannot extract a list from the message body");
    }

    @Override
    public <K, V> Map<K, V> bodyAsMap() {
        Object value = this.getAmqpValue();
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new IllegalStateException("Cannot extract a map from the message body");
    }

    @Override
    public JsonObject bodyAsJsonObject() {
        return this.bodyAsBinary().toJsonObject();
    }

    @Override
    public JsonArray bodyAsJsonArray() {
        return this.bodyAsBinary().toJsonArray();
    }

    @Override
    public String subject() {
        return this.message.getSubject();
    }

    @Override
    public String contentType() {
        return this.message.getContentType();
    }

    @Override
    public String contentEncoding() {
        return this.message.getContentType();
    }

    @Override
    public long expiryTime() {
        return this.message.getExpiryTime();
    }

    @Override
    public long creationTime() {
        return this.message.getCreationTime();
    }

    @Override
    public long ttl() {
        return this.message.getTtl();
    }

    @Override
    public int deliveryCount() {
        return (int)this.message.getDeliveryCount();
    }

    @Override
    public String groupId() {
        return this.message.getGroupId();
    }

    @Override
    public String replyToGroupId() {
        return this.message.getReplyToGroupId();
    }

    @Override
    public long groupSequence() {
        return this.message.getGroupSequence();
    }

    @Override
    public JsonObject applicationProperties() {
        ApplicationProperties properties = this.message.getApplicationProperties();
        if (properties == null) {
            return null;
        }
        return JsonObject.mapFrom((Object)properties.getValue());
    }

    @Override
    public Message unwrap() {
        return this.message;
    }

    public void delivered() {
        if (this.delivery != null) {
            ProtonHelper.accepted((ProtonDelivery)this.delivery, (boolean)true);
        }
    }
}

