/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqp.impl;

import io.vertx.amqp.AmqpConnection;
import io.vertx.amqp.AmqpMessage;
import io.vertx.amqp.AmqpReceiver;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.impl.AmqpConnectionImpl;
import io.vertx.amqp.impl.AmqpMessageImpl;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.proton.ProtonReceiver;
import java.util.ArrayDeque;
import java.util.Queue;

public class AmqpReceiverImpl
implements AmqpReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpReceiverImpl.class);
    private final ProtonReceiver receiver;
    private final AmqpConnectionImpl connection;
    private final Queue<AmqpMessageImpl> buffered = new ArrayDeque<AmqpMessageImpl>();
    private final boolean durable;
    private final boolean autoAck;
    private String address;
    private Handler<AmqpMessage> handler;
    private long demand = Long.MAX_VALUE;
    private boolean closed;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean initialCreditGiven;
    private int initialCredit = 1000;

    AmqpReceiverImpl(String address, AmqpConnectionImpl connection, AmqpReceiverOptions options, ProtonReceiver receiver, Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.address = address;
        this.receiver = receiver;
        this.connection = connection;
        this.durable = options.isDurable();
        this.autoAck = options.isAutoAcknowledgement();
        int maxBufferedMessages = options.getMaxBufferedMessages();
        if (maxBufferedMessages > 0) {
            this.initialCredit = maxBufferedMessages;
        }
        this.receiver.setAutoAccept(false).setPrefetch(0);
        this.receiver.handler((delivery, message) -> this.handleMessage(new AmqpMessageImpl(message, delivery, connection)));
        ((ProtonReceiver)this.receiver.closeHandler(res -> this.onClose(address, receiver, (AsyncResult<ProtonReceiver>)res, false))).detachHandler(res -> this.onClose(address, receiver, (AsyncResult<ProtonReceiver>)res, true));
        this.receiver.openHandler(res -> {
            if (res.failed()) {
                completionHandler.handle((Object)res.mapEmpty());
            } else {
                this.connection.register(this);
                AmqpReceiverImpl amqpReceiverImpl = this;
                synchronized (amqpReceiverImpl) {
                    if (this.address == null) {
                        this.address = ((ProtonReceiver)res.result()).getRemoteAddress();
                    }
                }
                completionHandler.handle((Object)Future.succeededFuture((Object)this));
            }
        });
        this.receiver.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClose(String address, ProtonReceiver receiver, AsyncResult<ProtonReceiver> res, boolean detach) {
        Handler<Void> endh = null;
        Handler<Throwable> exh = null;
        boolean closeReceiver = false;
        AmqpReceiverImpl amqpReceiverImpl = this;
        synchronized (amqpReceiverImpl) {
            if (!this.closed && this.endHandler != null) {
                endh = this.endHandler;
            } else if (!this.closed && this.exceptionHandler != null) {
                exh = this.exceptionHandler;
            }
            if (!this.closed) {
                this.closed = true;
                closeReceiver = true;
            }
        }
        if (endh != null) {
            endh.handle(null);
        } else if (exh != null) {
            if (res.succeeded()) {
                exh.handle((Object)new VertxException("Consumer closed remotely"));
            } else {
                exh.handle((Object)new VertxException("Consumer closed remotely with error", res.cause()));
            }
        } else if (res.succeeded()) {
            LOGGER.warn((Object)("Consumer for address " + address + " unexpectedly closed remotely"));
        } else {
            LOGGER.warn((Object)("Consumer for address " + address + " unexpectedly closed remotely with error"), res.cause());
        }
        if (closeReceiver) {
            if (detach) {
                receiver.detach();
            } else {
                receiver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(AmqpMessageImpl message) {
        Handler<AmqpMessage> h;
        boolean schedule = false;
        AmqpReceiverImpl amqpReceiverImpl = this;
        synchronized (amqpReceiverImpl) {
            h = this.handler;
            if (h == null || this.demand == 0L) {
                this.buffered.add(message);
                return;
            }
            if (!this.buffered.isEmpty()) {
                this.buffered.add(message);
                message = this.buffered.poll();
                schedule = true;
            }
            if (this.demand != Long.MAX_VALUE) {
                --this.demand;
            }
        }
        this.deliverMessageToHandler(h, message);
        if (schedule) {
            this.scheduleBufferedMessageDelivery();
        }
    }

    @Override
    public synchronized AmqpReceiver exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmqpReceiver handler(@Nullable Handler<AmqpMessage> handler) {
        int creditToFlow = 0;
        boolean schedule = false;
        AmqpReceiverImpl amqpReceiverImpl = this;
        synchronized (amqpReceiverImpl) {
            this.handler = handler;
            if (handler != null) {
                schedule = true;
                if (!this.initialCreditGiven) {
                    this.initialCreditGiven = true;
                    creditToFlow = this.initialCredit;
                }
            }
        }
        if (creditToFlow > 0) {
            int c = creditToFlow;
            this.connection.runWithTrampoline((Handler<Void>)((Handler)v -> this.receiver.flow(c)));
        }
        if (schedule) {
            this.scheduleBufferedMessageDelivery();
        }
        return this;
    }

    @Override
    public synchronized AmqpReceiverImpl pause() {
        this.demand = 0L;
        return this;
    }

    @Override
    public synchronized AmqpReceiverImpl fetch(long amount) {
        if (amount > 0L) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
            this.scheduleBufferedMessageDelivery();
        }
        return this;
    }

    @Override
    public synchronized AmqpReceiverImpl resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    @Override
    public synchronized AmqpReceiverImpl endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    private void deliverMessageToHandler(Handler<AmqpMessage> h, AmqpMessageImpl message) {
        block3: {
            try {
                h.handle((Object)message);
                if (this.autoAck) {
                    message.accepted();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unable to dispatch the AMQP message", (Throwable)e);
                if (!this.autoAck) break block3;
                message.rejected();
            }
        }
        this.receiver.flow(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleBufferedMessageDelivery() {
        boolean schedule;
        AmqpReceiverImpl amqpReceiverImpl = this;
        synchronized (amqpReceiverImpl) {
            schedule = !this.buffered.isEmpty() && this.demand > 0L;
        }
        if (schedule) {
            this.connection.runOnContext((Handler<Void>)((Handler)v -> {
                Handler<AmqpMessage> h;
                AmqpMessageImpl message = null;
                AmqpReceiverImpl amqpReceiverImpl = this;
                synchronized (amqpReceiverImpl) {
                    h = this.handler;
                    if (h != null && this.demand > 0L) {
                        message = this.buffered.poll();
                        if (this.demand != Long.MAX_VALUE && message != null) {
                            --this.demand;
                        }
                    }
                }
                if (message != null) {
                    this.deliverMessageToHandler(h, message);
                    this.scheduleBufferedMessageDelivery();
                }
            }));
        }
    }

    @Override
    public synchronized String address() {
        return this.address;
    }

    @Override
    public AmqpConnection connection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        Handler<AsyncResult<Void>> actualHandler = handler == null ? x -> {} : handler;
        AmqpReceiverImpl amqpReceiverImpl = this;
        synchronized (amqpReceiverImpl) {
            if (this.closed) {
                actualHandler.handle((Object)Future.succeededFuture());
                return;
            }
            this.closed = true;
        }
        this.connection.unregister(this);
        this.connection.runWithTrampoline((Handler<Void>)((Handler)x -> {
            block5: {
                if (this.receiver.isOpen()) {
                    try {
                        if (this.isDurable()) {
                            ((ProtonReceiver)this.receiver.detachHandler(done -> actualHandler.handle((Object)done.mapEmpty()))).detach();
                            break block5;
                        }
                        ((ProtonReceiver)this.receiver.closeHandler(done -> actualHandler.handle((Object)done.mapEmpty()))).close();
                    }
                    catch (Exception e) {
                        actualHandler.handle((Object)Future.failedFuture((Throwable)e));
                    }
                } else {
                    actualHandler.handle((Object)Future.succeededFuture());
                }
            }
        }));
    }

    private synchronized boolean isDurable() {
        return this.durable;
    }
}

