/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqp.impl;

import io.vertx.amqp.AmqpClient;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.amqp.AmqpConnection;
import io.vertx.amqp.AmqpReceiver;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSender;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.amqp.impl.AmqpConnectionImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class AmqpClientImpl
implements AmqpClient {
    private final Vertx vertx;
    private final ProtonClient proton;
    private final AmqpClientOptions options;
    private final List<AmqpConnection> connections = new CopyOnWriteArrayList<AmqpConnection>();
    private final boolean mustCloseVertxOnClose;

    public AmqpClientImpl(Vertx vertx, AmqpClientOptions options, boolean mustCloseVertxOnClose) {
        this.vertx = vertx;
        this.options = options == null ? new AmqpClientOptions() : options;
        this.proton = ProtonClient.create((Vertx)vertx);
        this.mustCloseVertxOnClose = mustCloseVertxOnClose;
    }

    @Override
    public AmqpClient connect(Handler<AsyncResult<AmqpConnection>> connectionHandler) {
        Objects.requireNonNull(this.options.getHost(), "Host must be set");
        Objects.requireNonNull(connectionHandler, "Handler must not be null");
        new AmqpConnectionImpl(this.vertx.getOrCreateContext(), this, this.options, this.proton, connectionHandler);
        return this;
    }

    @Override
    public Future<AmqpConnection> connect() {
        Promise promise = Promise.promise();
        this.connect((Handler<AsyncResult<AmqpConnection>>)promise);
        return promise.future();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        ArrayList<Future> actions = new ArrayList<Future>();
        for (AmqpConnection connection : this.connections) {
            Promise future = Promise.promise();
            connection.close((Handler<AsyncResult<Void>>)future);
            actions.add(future.future());
        }
        CompositeFuture.join(actions).onComplete(done -> {
            this.connections.clear();
            if (this.mustCloseVertxOnClose) {
                this.vertx.close(x -> {
                    if (done.succeeded() && x.succeeded()) {
                        if (handler != null) {
                            handler.handle((Object)Future.succeededFuture());
                        }
                    } else if (handler != null) {
                        handler.handle((Object)Future.failedFuture((Throwable)(done.failed() ? done.cause() : x.cause())));
                    }
                });
            } else if (handler != null) {
                handler.handle((Object)done.mapEmpty());
            }
        });
    }

    @Override
    public Future<Void> close() {
        Promise promise = Promise.promise();
        this.close((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public AmqpClient createReceiver(String address, Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        return this.connect((Handler<AsyncResult<AmqpConnection>>)((Handler)res -> {
            if (res.failed()) {
                completionHandler.handle((Object)res.mapEmpty());
            } else {
                ((AmqpConnection)res.result()).createReceiver(address, completionHandler);
            }
        }));
    }

    @Override
    public Future<AmqpReceiver> createReceiver(String address) {
        Promise promise = Promise.promise();
        this.createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)promise);
        return promise.future();
    }

    @Override
    public AmqpClient createReceiver(String address, AmqpReceiverOptions receiverOptions, Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        return this.connect((Handler<AsyncResult<AmqpConnection>>)((Handler)res -> {
            if (res.failed()) {
                completionHandler.handle((Object)res.mapEmpty());
            } else {
                ((AmqpConnection)res.result()).createReceiver(address, receiverOptions, completionHandler);
            }
        }));
    }

    @Override
    public Future<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        Promise promise = Promise.promise();
        this.createReceiver(address, receiverOptions, (Handler<AsyncResult<AmqpReceiver>>)promise);
        return promise.future();
    }

    @Override
    public AmqpClient createSender(String address, Handler<AsyncResult<AmqpSender>> completionHandler) {
        return this.connect((Handler<AsyncResult<AmqpConnection>>)((Handler)res -> {
            if (res.failed()) {
                completionHandler.handle((Object)res.mapEmpty());
            } else {
                ((AmqpConnection)res.result()).createSender(address, completionHandler);
            }
        }));
    }

    @Override
    public Future<AmqpSender> createSender(String address) {
        Promise promise = Promise.promise();
        this.createSender(address, (Handler<AsyncResult<AmqpSender>>)promise);
        return promise.future();
    }

    @Override
    public AmqpClient createSender(String address, AmqpSenderOptions options, Handler<AsyncResult<AmqpSender>> completionHandler) {
        return this.connect((Handler<AsyncResult<AmqpConnection>>)((Handler)res -> {
            if (res.failed()) {
                completionHandler.handle((Object)res.mapEmpty());
            } else {
                ((AmqpConnection)res.result()).createSender(address, options, completionHandler);
            }
        }));
    }

    @Override
    public Future<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        Promise promise = Promise.promise();
        this.createSender(address, options, (Handler<AsyncResult<AmqpSender>>)promise);
        return promise.future();
    }

    synchronized void register(AmqpConnectionImpl connection) {
        this.connections.add(connection);
    }
}

