/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqp;

import io.vertx.amqp.AmqpClientOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.proton.ProtonClientOptions;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

@DataObject
@JsonGen(publicConverter=false)
public class AmqpClientOptions
extends ProtonClientOptions {
    private String host = this.getFromSysOrEnv("amqp-client-host");
    private int port = this.getPortFromSysOrEnv();
    private String username = this.getFromSysOrEnv("amqp-client-username");
    private String password = this.getFromSysOrEnv("amqp-client-password");
    private String containerId = UUID.randomUUID().toString();
    private String connectionHostname = null;

    public AmqpClientOptions() {
    }

    public AmqpClientOptions(JsonObject json) {
        super(json);
        AmqpClientOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public AmqpClientOptions(AmqpClientOptions other) {
        super((ProtonClientOptions)other);
        this.host = other.host;
        this.password = other.password;
        this.username = other.username;
        this.port = other.port;
        this.containerId = other.containerId;
        this.connectionHostname = other.connectionHostname;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        AmqpClientOptionsConverter.toJson(this, json);
        return json;
    }

    public String getHost() {
        return this.host;
    }

    public AmqpClientOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public AmqpClientOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public AmqpClientOptions setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public AmqpClientOptions setPassword(String pwd) {
        this.password = pwd;
        return this;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public AmqpClientOptions setContainerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    public String getConnectionHostname() {
        return this.connectionHostname;
    }

    public AmqpClientOptions setConnectionHostname(String hostname) {
        this.connectionHostname = hostname;
        return this;
    }

    public AmqpClientOptions addEnabledSaslMechanism(String saslMechanism) {
        super.addEnabledSaslMechanism(saslMechanism);
        return this;
    }

    public AmqpClientOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    public AmqpClientOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public AmqpClientOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    public AmqpClientOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    public AmqpClientOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    public AmqpClientOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    public AmqpClientOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    public AmqpClientOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    public AmqpClientOptions setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        super.setIdleTimeoutUnit(idleTimeoutUnit);
        return this;
    }

    public AmqpClientOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public AmqpClientOptions setSslHandshakeTimeout(long sslHandshakeTimeout) {
        super.setSslHandshakeTimeout(sslHandshakeTimeout);
        return this;
    }

    public AmqpClientOptions setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        super.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
        return this;
    }

    public AmqpClientOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    public AmqpClientOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    public AmqpClientOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    public AmqpClientOptions addCrlPath(String crlPath) {
        super.addCrlPath(crlPath);
        return this;
    }

    public AmqpClientOptions addCrlValue(Buffer crlValue) {
        super.addCrlValue(crlValue);
        return this;
    }

    public AmqpClientOptions setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    public AmqpClientOptions setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    public AmqpClientOptions setReconnectAttempts(int attempts) {
        super.setReconnectAttempts(attempts);
        return this;
    }

    public AmqpClientOptions setReconnectInterval(long interval) {
        super.setReconnectInterval(interval);
        return this;
    }

    public AmqpClientOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public AmqpClientOptions setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        super.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
        return this;
    }

    public AmqpClientOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        super.setSslEngineOptions(sslEngineOptions);
        return this;
    }

    public AmqpClientOptions setLocalAddress(String localAddress) {
        super.setLocalAddress(localAddress);
        return this;
    }

    public AmqpClientOptions setReusePort(boolean reusePort) {
        super.setReusePort(reusePort);
        return this;
    }

    public AmqpClientOptions setTcpCork(boolean tcpCork) {
        super.setTcpCork(tcpCork);
        return this;
    }

    public AmqpClientOptions setTcpFastOpen(boolean tcpFastOpen) {
        super.setTcpFastOpen(tcpFastOpen);
        return this;
    }

    public AmqpClientOptions setTcpQuickAck(boolean tcpQuickAck) {
        super.setTcpQuickAck(tcpQuickAck);
        return this;
    }

    public AmqpClientOptions removeEnabledSecureTransportProtocol(String protocol) {
        super.removeEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public AmqpClientOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
        return this;
    }

    public AmqpClientOptions setVirtualHost(String virtualHost) {
        super.setVirtualHost(virtualHost);
        return this;
    }

    public AmqpClientOptions setSniServerName(String sniServerName) {
        super.setSniServerName(sniServerName);
        return this;
    }

    public AmqpClientOptions setHeartbeat(int heartbeat) {
        super.setHeartbeat(heartbeat);
        return this;
    }

    public AmqpClientOptions setMaxFrameSize(int maxFrameSize) {
        super.setMaxFrameSize(maxFrameSize);
        return this;
    }

    private String getFromSysOrEnv(String key) {
        String sys = System.getProperty(key);
        if (sys == null) {
            return System.getenv(key.toUpperCase().replace("-", "_"));
        }
        return sys;
    }

    private int getPortFromSysOrEnv() {
        String s = this.getFromSysOrEnv("amqp-client-port");
        if (s == null) {
            return 5672;
        }
        return Integer.parseInt(s);
    }
}

