/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqp.impl;

import io.vertx.amqp.AmqpConnection;
import io.vertx.amqp.AmqpMessage;
import io.vertx.amqp.AmqpSender;
import io.vertx.amqp.impl.AmqpConnectionImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.proton.ProtonSender;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.DeliveryState;

public class AmqpSenderImpl
implements AmqpSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpSender.class);
    private final ProtonSender sender;
    private final AmqpConnectionImpl connection;
    private boolean closed;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> drainHandler;
    private long remoteCredit = 0L;

    private AmqpSenderImpl(ProtonSender sender, AmqpConnectionImpl connection, Completable<AmqpSender> completionHandler) {
        this.sender = sender;
        this.connection = connection;
        ((ProtonSender)sender.closeHandler(res -> this.onClose(sender, (AsyncResult<ProtonSender>)res, false))).detachHandler(res -> this.onClose(sender, (AsyncResult<ProtonSender>)res, true));
        sender.sendQueueDrainHandler(s -> {
            Handler<Void> dh = null;
            AmqpSenderImpl amqpSenderImpl = this;
            synchronized (amqpSenderImpl) {
                this.remoteCredit = sender.getRemoteCredit();
                if (this.drainHandler != null) {
                    dh = this.drainHandler;
                }
            }
            if (dh != null) {
                dh.handle(null);
            }
        });
        sender.openHandler(done -> {
            if (done.failed()) {
                completionHandler.complete(null, done.cause());
            } else {
                connection.register(this);
                completionHandler.succeed((Object)this);
            }
        });
        sender.open();
    }

    static void create(ProtonSender sender, AmqpConnectionImpl connection, Completable<AmqpSender> completionHandler) {
        new AmqpSenderImpl(sender, connection, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClose(ProtonSender sender, AsyncResult<ProtonSender> res, boolean detach) {
        Handler<Throwable> eh = null;
        boolean closeSender = false;
        AmqpSenderImpl amqpSenderImpl = this;
        synchronized (amqpSenderImpl) {
            if (!this.closed && this.exceptionHandler != null) {
                eh = this.exceptionHandler;
            }
            if (!this.closed) {
                this.closed = true;
                closeSender = true;
            }
        }
        if (eh != null) {
            if (res.succeeded()) {
                eh.handle((Object)new Exception("Sender closed remotely"));
            } else {
                eh.handle((Object)new Exception("Sender closed remotely with error", res.cause()));
            }
        }
        if (closeSender) {
            if (detach) {
                sender.detach();
            } else {
                sender.close();
            }
        }
    }

    public synchronized boolean writeQueueFull() {
        return this.remoteCredit <= 0L;
    }

    @Override
    public AmqpConnection connection() {
        return this.connection;
    }

    @Override
    public AmqpSender send(AmqpMessage message) {
        return this.doSend(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AmqpSender doSend(AmqpMessage message, Completable<Void> acknowledgmentHandler) {
        Handler ack = delivery -> {
            DeliveryState remoteState = delivery.getRemoteState();
            Completable handler = acknowledgmentHandler;
            if (acknowledgmentHandler == null) {
                handler = (res, err) -> {
                    if (err != null) {
                        LOGGER.warn((Object)"Message rejected by remote peer", err);
                    }
                };
            }
            if (remoteState == null) {
                handler.fail("Unknown message state");
                return;
            }
            switch (remoteState.getType()) {
                case Rejected: {
                    handler.fail("message rejected (REJECTED): " + ((Rejected)remoteState).getError());
                    break;
                }
                case Modified: {
                    handler.fail("message rejected (MODIFIED)");
                    break;
                }
                case Released: {
                    handler.fail("message rejected (RELEASED)");
                    break;
                }
                case Accepted: {
                    handler.succeed();
                    break;
                }
                default: {
                    handler.fail("Unsupported delivery type: " + remoteState.getType());
                }
            }
        };
        AmqpSenderImpl amqpSenderImpl = this;
        synchronized (amqpSenderImpl) {
            --this.remoteCredit;
        }
        this.connection.runWithTrampoline((Handler<Void>)((Handler)x -> {
            AmqpMessage updated = message.address() == null ? AmqpMessage.create(message).address(this.address()).build() : message;
            this.sender.send(updated.unwrap(), ack);
            AmqpSenderImpl amqpSenderImpl = this;
            synchronized (amqpSenderImpl) {
                this.remoteCredit = this.sender.getRemoteCredit();
            }
        }));
        return this;
    }

    @Override
    public synchronized AmqpSender exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public Future<Void> write(AmqpMessage data) {
        Promise promise = Promise.promise();
        this.doSend(data, (Completable<Void>)promise);
        return promise.future();
    }

    @Override
    public AmqpSender setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    public Future<Void> end() {
        Promise promise = Promise.promise();
        this.close((Completable<Void>)promise);
        return promise.future();
    }

    public synchronized AmqpSender drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    public AmqpSender sendWithAck(AmqpMessage message, Promise<Void> acknowledgementHandler) {
        return this.doSend(message, (Completable<Void>)acknowledgementHandler);
    }

    @Override
    public Future<Void> sendWithAck(AmqpMessage message) {
        Promise promise = Promise.promise();
        this.sendWithAck(message, (Promise<Void>)promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Completable<Void> handler) {
        Completable<Void> actualHandler = handler == null ? (res, err) -> {} : handler;
        AmqpSenderImpl amqpSenderImpl = this;
        synchronized (amqpSenderImpl) {
            if (this.closed) {
                actualHandler.succeed();
                return;
            }
            this.closed = true;
        }
        this.connection.unregister(this);
        this.connection.runWithTrampoline((Handler<Void>)((Handler)x -> {
            if (this.sender.isOpen()) {
                try {
                    ((ProtonSender)this.sender.closeHandler(v -> actualHandler.complete(null, v.cause()))).close();
                }
                catch (Exception e) {
                    actualHandler.fail((Throwable)e);
                }
            } else {
                actualHandler.succeed();
            }
        }));
    }

    @Override
    public Future<Void> close() {
        Promise promise = Promise.promise();
        this.close((Completable<Void>)promise);
        return promise.future();
    }

    @Override
    public String address() {
        return this.sender.getRemoteAddress();
    }

    @Override
    public long remainingCredits() {
        return this.sender.getRemoteCredit();
    }

    @Override
    public ProtonSender unwrap() {
        return this.sender;
    }
}

