/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqp.impl;

import io.vertx.amqp.AmqpClient;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.amqp.AmqpConnection;
import io.vertx.amqp.AmqpReceiver;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSender;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.amqp.impl.AmqpConnectionImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.proton.ProtonClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class AmqpClientImpl
implements AmqpClient {
    private final Vertx vertx;
    private final ProtonClient proton;
    private final AmqpClientOptions options;
    private final List<AmqpConnection> connections = new CopyOnWriteArrayList<AmqpConnection>();
    private final boolean mustCloseVertxOnClose;

    public AmqpClientImpl(Vertx vertx, AmqpClientOptions options, boolean mustCloseVertxOnClose) {
        this.vertx = vertx;
        this.options = options == null ? new AmqpClientOptions() : options;
        this.proton = ProtonClient.create((Vertx)vertx);
        this.mustCloseVertxOnClose = mustCloseVertxOnClose;
    }

    public AmqpClient connect(Handler<AsyncResult<AmqpConnection>> connectionHandler) {
        Objects.requireNonNull(connectionHandler, "Handler must not be null");
        this.connect().onComplete(connectionHandler);
        return this;
    }

    @Override
    public Future<AmqpConnection> connect() {
        Objects.requireNonNull(this.options.getHost(), "Host must be set");
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        new AmqpConnectionImpl((Context)ctx, this.options, this.proton, (Promise<AmqpConnection>)promise);
        Future future = promise.future();
        future.onSuccess(conn -> {
            this.connections.add((AmqpConnection)conn);
            conn.closeFuture().onComplete(ar -> this.connections.remove(conn));
        });
        return future;
    }

    public void close(Completable<Void> handler) {
        ArrayList<Future<Void>> actions = new ArrayList<Future<Void>>();
        for (AmqpConnection connection : this.connections) {
            actions.add(connection.close());
        }
        Future.join(actions).onComplete(done -> {
            this.connections.clear();
            if (this.mustCloseVertxOnClose) {
                this.vertx.close().onComplete(x -> {
                    if (done.succeeded() && x.succeeded()) {
                        if (handler != null) {
                            handler.succeed();
                        }
                    } else if (handler != null) {
                        handler.fail(done.failed() ? done.cause() : x.cause());
                    }
                });
            } else if (handler != null) {
                handler.complete(null, done.cause());
            }
        });
    }

    @Override
    public Future<Void> close() {
        Promise promise = Promise.promise();
        this.close((Completable<Void>)promise);
        return promise.future();
    }

    public AmqpClient createReceiver(String address, Completable<AmqpReceiver> completionHandler) {
        return this.connect((Handler<AsyncResult<AmqpConnection>>)((Handler)res -> {
            if (res.failed()) {
                completionHandler.complete(null, res.cause());
            } else {
                ((AmqpConnection)res.result()).createReceiver(address).onComplete(completionHandler);
            }
        }));
    }

    @Override
    public Future<AmqpReceiver> createReceiver(String address) {
        Promise promise = Promise.promise();
        this.createReceiver(address, (Completable<AmqpReceiver>)promise);
        return promise.future();
    }

    public AmqpClient createReceiver(String address, AmqpReceiverOptions receiverOptions, Completable<AmqpReceiver> completionHandler) {
        return this.connect((Handler<AsyncResult<AmqpConnection>>)((Handler)res -> {
            if (res.failed()) {
                completionHandler.complete(null, res.cause());
            } else {
                ((AmqpConnection)res.result()).createReceiver(address, receiverOptions).onComplete(completionHandler);
            }
        }));
    }

    @Override
    public Future<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        Promise promise = Promise.promise();
        this.createReceiver(address, receiverOptions, (Completable<AmqpReceiver>)promise);
        return promise.future();
    }

    public AmqpClient createSender(String address, Completable<AmqpSender> completionHandler) {
        return this.connect((Handler<AsyncResult<AmqpConnection>>)((Handler)res -> {
            if (res.failed()) {
                completionHandler.complete(null, res.cause());
            } else {
                ((AmqpConnection)res.result()).createSender(address).onComplete(completionHandler);
            }
        }));
    }

    @Override
    public Future<AmqpSender> createSender(String address) {
        Promise promise = Promise.promise();
        this.createSender(address, (Completable<AmqpSender>)promise);
        return promise.future();
    }

    public AmqpClient createSender(String address, AmqpSenderOptions options, Completable<AmqpSender> completionHandler) {
        return this.connect((Handler<AsyncResult<AmqpConnection>>)((Handler)res -> {
            if (res.failed()) {
                completionHandler.complete(null, res.cause());
            } else {
                ((AmqpConnection)res.result()).createSender(address, options).onComplete(completionHandler);
            }
        }));
    }

    @Override
    public Future<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        Promise promise = Promise.promise();
        this.createSender(address, options, (Completable<AmqpSender>)promise);
        return promise.future();
    }

    public int numConnections() {
        return this.connections.size();
    }
}

