/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 *
 * User-facing interface for authenticating users.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.AuthProvider original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.auth.AuthProvider.class)
public class AuthProvider {

  public static final io.vertx.lang.rxjava.TypeArg<AuthProvider> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new AuthProvider((io.vertx.ext.auth.AuthProvider) obj),
    AuthProvider::getDelegate
  );

  private final io.vertx.ext.auth.AuthProvider delegate;
  
  public AuthProvider(io.vertx.ext.auth.AuthProvider delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.AuthProvider getDelegate() {
    return delegate;
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a JSON object containing information for authenticating the user. What this actually contains
   * depends on the specific implementation. In the case of a simple username/password based
   * authentication it is likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username": "tim",
   *     "password": "mypassword"
   *   }
   * </pre>
   * For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
   * <p>
   * If the user is successfully authenticated a {@link io.vertx.rxjava.ext.auth.User} object is passed to the handler in an {@link io.vertx.rxjava.core.AsyncResult}.
   * The user object can then be used for authorisation.
   * @param authInfo The auth information
   * @param resultHandler The result handler
   */
  public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) { 
    delegate.authenticate(authInfo, new Handler<AsyncResult<io.vertx.ext.auth.User>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.User> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(User.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a JSON object containing information for authenticating the user. What this actually contains
   * depends on the specific implementation. In the case of a simple username/password based
   * authentication it is likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username": "tim",
   *     "password": "mypassword"
   *   }
   * </pre>
   * For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
   * <p>
   * If the user is successfully authenticated a {@link io.vertx.rxjava.ext.auth.User} object is passed to the handler in an {@link io.vertx.rxjava.core.AsyncResult}.
   * The user object can then be used for authorisation.
   * @param authInfo The auth information
   * @return 
   * @deprecated use {@link #rxAuthenticate} instead
   */
  @Deprecated()
  public Observable<User> authenticateObservable(JsonObject authInfo) { 
    io.vertx.rx.java.ObservableFuture<User> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    authenticate(authInfo, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a JSON object containing information for authenticating the user. What this actually contains
   * depends on the specific implementation. In the case of a simple username/password based
   * authentication it is likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username": "tim",
   *     "password": "mypassword"
   *   }
   * </pre>
   * For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
   * <p>
   * If the user is successfully authenticated a {@link io.vertx.rxjava.ext.auth.User} object is passed to the handler in an {@link io.vertx.rxjava.core.AsyncResult}.
   * The user object can then be used for authorisation.
   * @param authInfo The auth information
   * @return 
   */
  public Single<User> rxAuthenticate(JsonObject authInfo) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      authenticate(authInfo, fut);
    }));
  }


  public static AuthProvider newInstance(io.vertx.ext.auth.AuthProvider arg) {
    return arg != null ? new AuthProvider(arg) : null;
  }
}
