/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.UUID;

@VertxGen
public interface AuthStore {
    default public String generateId() {
        return UUID.randomUUID().toString();
    }

    @Fluent
    default public AuthStore getUserCredentialsByName(String username, Handler<AsyncResult<List<JsonObject>>> handler) {
        handler.handle((Object)Future.failedFuture((String)"getUserCredentials not supported"));
        return this;
    }

    default public Future<List<JsonObject>> getUserCredentialsByName(String username) {
        Promise promise = Promise.promise();
        this.getUserCredentialsByName(username, (Handler<AsyncResult<List<JsonObject>>>)promise);
        return promise.future();
    }

    @Fluent
    default public AuthStore getUserCredentialsById(String rawId, Handler<AsyncResult<List<JsonObject>>> handler) {
        handler.handle((Object)Future.failedFuture((String)"getUserCredentials not supported"));
        return this;
    }

    default public Future<List<JsonObject>> getUserCredentialsById(String rawId) {
        Promise promise = Promise.promise();
        this.getUserCredentialsById(rawId, (Handler<AsyncResult<List<JsonObject>>>)promise);
        return promise.future();
    }

    @Fluent
    default public AuthStore updateUserCredential(String id, JsonObject data, boolean upsert, Handler<AsyncResult<Void>> handler) {
        handler.handle((Object)Future.failedFuture((String)"updateUserCredentials not supported"));
        return this;
    }

    default public Future<Void> updateUserCredential(String id, JsonObject data, boolean upsert) {
        Promise promise = Promise.promise();
        this.updateUserCredential(id, data, upsert, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Fluent
    default public AuthStore getUserRoles(String id, Handler<AsyncResult<List<String>>> handler) {
        handler.handle((Object)Future.failedFuture((String)"getUserRoles not supported"));
        return this;
    }

    default public Future<List<String>> getUserRoles(String id) {
        Promise promise = Promise.promise();
        this.getUserRoles(id, (Handler<AsyncResult<List<String>>>)promise);
        return promise.future();
    }

    @Fluent
    default public AuthStore getUserPermissions(String id, Handler<AsyncResult<List<String>>> handler) {
        handler.handle((Object)Future.failedFuture((String)"getUserPermissions not supported"));
        return this;
    }

    default public Future<List<String>> getUserPermissions(String id) {
        Promise promise = Promise.promise();
        this.getUserPermissions(id, (Handler<AsyncResult<List<String>>>)promise);
        return promise.future();
    }
}

