/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.authorization.Authorizations;
import io.vertx.ext.auth.authorization.impl.AuthorizationsImpl;
import io.vertx.ext.auth.impl.UserImpl;

@VertxGen
public interface User {
    public static User create(JsonObject principal) {
        return User.create(principal, new JsonObject());
    }

    public static User create(JsonObject principal, JsonObject attributes) {
        return new UserImpl(principal, attributes);
    }

    public JsonObject attributes();

    default public boolean expired() {
        return this.expired(this.attributes().getInteger("leeway", Integer.valueOf(0)));
    }

    default public boolean expired(int leeway) {
        Long nbf;
        Long iat;
        long now = System.currentTimeMillis() / 1000L;
        if ((this.principal().containsKey("exp") || this.attributes().containsKey("exp")) && now - (long)leeway >= this.principal().getLong("exp", this.attributes().getLong("exp"))) {
            return true;
        }
        if ((this.principal().containsKey("iat") || this.attributes().containsKey("iat")) && (iat = this.principal().getLong("iat", this.attributes().getLong("iat"))) > now + (long)leeway) {
            return true;
        }
        return (this.principal().containsKey("nbf") || this.attributes().containsKey("nbf")) && (nbf = this.principal().getLong("nbf", this.attributes().getLong("nbf"))) > now + (long)leeway;
    }

    default public Authorizations authorizations() {
        return new AuthorizationsImpl();
    }

    @Fluent
    public User isAuthorized(String var1, Handler<AsyncResult<Boolean>> var2);

    default public Future<Boolean> isAuthorized(String authority) {
        Promise promise = Promise.promise();
        this.isAuthorized(authority, (Handler<AsyncResult<Boolean>>)promise);
        return promise.future();
    }

    @Fluent
    public User clearCache();

    public JsonObject principal();

    @Deprecated
    public void setAuthProvider(AuthProvider var1);
}

