/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CertificateHelper {
    private CertificateHelper() {
    }

    public static void checkValidity(List<X509Certificate> certificates) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException {
        for (int i = 0; i < certificates.size(); ++i) {
            X509Certificate subjectCert = certificates.get(i);
            subjectCert.checkValidity();
            if (certificates.size() == 1) {
                return;
            }
            X509Certificate issuerCert = i + 1 >= certificates.size() ? subjectCert : certificates.get(i + 1);
            if (!subjectCert.getIssuerX500Principal().equals(issuerCert.getSubjectX500Principal())) {
                throw new CertificateException("Certificate path issuers dont match: [" + subjectCert.getIssuerX500Principal() + "] != [" + issuerCert.getSubjectX500Principal() + "]");
            }
            subjectCert.verify(issuerCert.getPublicKey());
        }
        X509Certificate root = certificates.get(certificates.size() - 1);
        root.verify(root.getPublicKey());
    }

    public static CertInfo getCertInfo(X509Certificate cert) {
        String subject = cert.getSubjectX500Principal().getName("RFC2253");
        HashMap<String, String> sub = null;
        if (subject != null && !"".equals(subject)) {
            String[] values = subject.split(",");
            sub = new HashMap<String, String>();
            for (String value : values) {
                int idx = value.indexOf(61);
                if (idx != -1) {
                    sub.put(value.substring(0, idx), value.substring(idx + 1));
                    continue;
                }
                sub.put(value, null);
            }
        }
        return new CertInfo(sub, cert.getVersion(), cert.getBasicConstraints());
    }

    public static final class CertInfo {
        private final Map<String, String> subject;
        private final int version;
        private final int basicConstraintsCA;

        private CertInfo(Map<String, String> subject, int version, int basicConstraintsCA) {
            this.subject = subject;
            this.version = version;
            this.basicConstraintsCA = basicConstraintsCA;
        }

        public boolean subjectHas(String key) {
            if (this.subject != null) {
                return this.subject.containsKey(key);
            }
            return false;
        }

        public String subject(String key) {
            if (this.subject != null) {
                return this.subject.get(key);
            }
            return null;
        }

        public int version() {
            return this.version;
        }

        public int basicConstraintsCA() {
            return this.basicConstraintsCA;
        }

        public boolean isEmpty() {
            if (this.subject != null) {
                return this.subject.isEmpty();
            }
            return true;
        }
    }
}

