/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl.jose;

public final class SignatureHelper {
    private SignatureHelper() {
        throw new RuntimeException("Should not be instantiated.");
    }

    public static byte[] toJWS(byte[] derSignature, int signatureLength) {
        int sLength;
        int j;
        int rLength;
        int i;
        int offset;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        if (derSignature[1] > 0) {
            offset = 2;
        } else if (derSignature[1] == -127) {
            offset = 3;
        } else {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        for (i = rLength = derSignature[offset + 1]; i > 0 && derSignature[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = derSignature[offset + 2 + rLength + 1]; j > 0 && derSignature[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int rawLen = Math.max(i, j);
        rawLen = Math.max(rawLen, signatureLength / 2);
        if ((derSignature[offset - 1] & 0xFF) != derSignature.length - offset || (derSignature[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || derSignature[offset] != 2 || derSignature[offset + 2 + rLength] != 2) {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        byte[] concatSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, offset + 2 + rLength - i, concatSignature, rawLen - i, i);
        System.arraycopy(derSignature, offset + 2 + rLength + 2 + sLength - j, concatSignature, 2 * rawLen - j, j);
        return concatSignature;
    }

    public static byte[] toASN1(byte[] jwsSignature) {
        int offset;
        byte[] derSignature;
        int len;
        int k;
        int rawLen;
        int i;
        for (i = rawLen = jwsSignature.length / 2; i > 0 && jwsSignature[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (jwsSignature[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && jwsSignature[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (jwsSignature[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = 2 + j + 2 + l) > 255) {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        if (len < 128) {
            derSignature = new byte[4 + j + 2 + l];
            offset = 1;
        } else {
            derSignature = new byte[5 + j + 2 + l];
            derSignature[1] = -127;
            offset = 2;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)len;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)j;
        System.arraycopy(jwsSignature, rawLen - i, derSignature, offset + j - i, i);
        offset += j;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)l;
        System.arraycopy(jwsSignature, 2 * rawLen - k, derSignature, offset + l - k, k);
        return derSignature;
    }

    public static boolean isASN1(byte[] sig) {
        if (sig.length < 8) {
            return false;
        }
        try {
            int offset;
            if (sig[0] != 48) {
                return false;
            }
            if (sig.length < 128) {
                offset = 0;
            } else {
                if (sig[1] != -127) {
                    return false;
                }
                offset = 1;
            }
            if (sig[offset + 1] + 2 != sig.length) {
                return false;
            }
            if (sig[offset += 2] != 2) {
                return false;
            }
            if (offset + sig[offset + 1] + 2 > sig.length) {
                return false;
            }
            if (sig[offset = offset + sig[offset + 1] + 2] != 2) {
                return false;
            }
            if (offset + sig[offset + 1] + 2 > sig.length) {
                return false;
            }
            return (offset = offset + sig[offset + 1] + 2) == sig.length;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }
}

