/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htdigest;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.htdigest.HtdigestCredentialsConverter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DataObject(generateConverter=true, publicConverter=false)
public class HtdigestCredentials
extends UsernamePasswordCredentials
implements Credentials {
    private static final Pattern PARSER = Pattern.compile("(\\w+)=[\"]?([^\"]*)[\"]?$");
    private static final Pattern SPLITTER = Pattern.compile(",(?=(?:[^\"]|\"[^\"]*\")*$)");
    private String algorithm;
    private String cnonce;
    private String method;
    private String nc;
    private String nonce;
    private String opaque;
    private String qop;
    private String realm;
    private String response;
    private String uri;
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    public HtdigestCredentials() {
    }

    public HtdigestCredentials(String username, String password) {
        super(username, password);
    }

    public HtdigestCredentials(JsonObject jsonObject) {
        HtdigestCredentialsConverter.fromJson((Iterable<Map.Entry<String, Object>>)jsonObject, this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public String getMethod() {
        return this.method;
    }

    public String getNc() {
        return this.nc;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getQop() {
        return this.qop;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getResponse() {
        return this.response;
    }

    public String getUri() {
        return this.uri;
    }

    public HtdigestCredentials setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public HtdigestCredentials setCnonce(String cnonce) {
        this.cnonce = cnonce;
        return this;
    }

    public HtdigestCredentials setMethod(String method) {
        this.method = method;
        return this;
    }

    public HtdigestCredentials setNc(String nc) {
        this.nc = nc;
        return this;
    }

    public HtdigestCredentials setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    public HtdigestCredentials setOpaque(String opaque) {
        this.opaque = opaque;
        return this;
    }

    public HtdigestCredentials setQop(String qop) {
        this.qop = qop;
        return this;
    }

    public HtdigestCredentials setRealm(String realm) {
        this.realm = realm;
        return this;
    }

    public HtdigestCredentials setResponse(String response) {
        this.response = response;
        return this;
    }

    public HtdigestCredentials setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public HtdigestCredentials setUsername(String username) {
        super.setUsername(username);
        return this;
    }

    public HtdigestCredentials setPassword(String password) {
        super.setPassword(password);
        return this;
    }

    public <V> void checkValid(V arg) throws CredentialValidationException {
        String username = this.getUsername();
        if (username == null || username.length() == 0) {
            throw new CredentialValidationException("username cannot be null or empty");
        }
        if (this.realm == null) {
            throw new CredentialValidationException("realm cannot be null");
        }
        if (arg != null && ((Boolean)arg).booleanValue()) {
            if (this.getPassword() == null) {
                throw new CredentialValidationException("password cannot be null");
            }
            if (this.nonce == null) {
                throw new CredentialValidationException("nonce cannot be null");
            }
            if (this.opaque == null) {
                throw new CredentialValidationException("opaque cannot be null");
            }
            if (this.method == null) {
                throw new CredentialValidationException("method cannot be null");
            }
            if (this.uri == null) {
                throw new CredentialValidationException("uri cannot be null");
            }
            if (this.qop != null) {
                String[] qops = this.qop.split(",");
                boolean found = false;
                for (String q : qops) {
                    if (!"auth".equals(q)) continue;
                    this.qop = "auth";
                    found = true;
                    break;
                }
                if (!found) {
                    throw new CredentialValidationException(this.qop + " qop is not supported");
                }
                if (this.nc == null) {
                    throw new CredentialValidationException("nc cannot be null");
                }
                if (this.cnonce == null) {
                    throw new CredentialValidationException("cnonce cannot be null");
                }
            }
        } else if (this.response == null) {
            throw new CredentialValidationException("response cannot be null");
        }
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        HtdigestCredentialsConverter.toJson(this, result);
        return result;
    }

    public String toString() {
        return this.toJson().encode();
    }

    public HtdigestCredentials applyHttpChallenge(String challenge, HttpMethod method, String uri, Integer nc, String cnonce) throws CredentialValidationException {
        if (challenge == null) {
            throw new IllegalArgumentException("Digest auth requires a challenge");
        }
        int spc = challenge.indexOf(32);
        if (!"Digest".equalsIgnoreCase(challenge.substring(0, spc))) {
            throw new IllegalArgumentException("Only 'Digest' auth-scheme is supported");
        }
        String[] tokens = SPLITTER.split(challenge.substring(spc + 1));
        int len = tokens.length;
        block14: for (int i = 0; i < len; ++i) {
            Matcher m = PARSER.matcher(tokens[i]);
            if (!m.find()) continue;
            switch (m.group(1)) {
                case "nonce": {
                    this.nonce = m.group(2);
                    continue block14;
                }
                case "opaque": {
                    this.opaque = m.group(2);
                    continue block14;
                }
                case "qop": {
                    this.qop = m.group(2);
                    continue block14;
                }
                case "algorithm": {
                    this.algorithm = m.group(2);
                    continue block14;
                }
                case "realm": {
                    this.realm = m.group(2);
                }
            }
        }
        this.method = method != null ? method.name() : null;
        this.uri = uri;
        this.nc = nc != null ? nc.toString() : null;
        this.cnonce = cnonce;
        this.checkValid(true);
        return this;
    }

    public String toHttpAuthorization() {
        MessageDigest MD5;
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] ha1 = MD5.digest(String.join((CharSequence)":", this.getUsername(), this.realm, this.getPassword()).getBytes(StandardCharsets.UTF_8));
        if ("MD5-sess".equals(this.algorithm)) {
            ha1 = MD5.digest(Buffer.buffer().appendBytes(ha1).appendByte((byte)58).appendString(this.nonce).appendByte((byte)58).appendString(this.cnonce).getBytes());
        }
        byte[] ha2 = MD5.digest(String.join((CharSequence)":", this.method, this.uri).getBytes(StandardCharsets.UTF_8));
        Buffer response = Buffer.buffer().appendString(HtdigestCredentials.bytesToHex(ha1)).appendByte((byte)58).appendString(this.nonce);
        if (this.qop != null) {
            response.appendByte((byte)58).appendString(this.nc).appendByte((byte)58).appendString(this.cnonce).appendByte((byte)58).appendString(this.qop);
        }
        response.appendByte((byte)58).appendString(HtdigestCredentials.bytesToHex(ha2));
        Buffer header = Buffer.buffer((String)"Digest ");
        header.appendString("username=\"").appendString(this.getUsername().replaceAll("\"", "\\\"")).appendString("\", realm=\"").appendString(this.realm).appendString("\", nonce=\"").appendString(this.nonce).appendString("\", uri=\"").appendString(this.uri);
        if (this.qop != null) {
            header.appendString("\", qop=").appendString(this.qop).appendString(", nc=").appendString(this.nc).appendString(", cnonce=\"").appendString(this.cnonce.replaceAll("\"", "\\\""));
        }
        header.appendString("\", response=\"").appendString(HtdigestCredentials.bytesToHex(MD5.digest(response.getBytes()))).appendString("\", opaque=\"").appendString(this.opaque).appendString("\"");
        return header.toString();
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

