/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htpasswd;

import io.vertx.core.Vertx;
import io.vertx.ext.auth.AuthOptions;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.htpasswd.HtpasswdAuth;

public class HtpasswdAuthOptions
implements AuthOptions {
    private boolean usersAuthorizedForEverything;
    private String htpasswdFile;
    private boolean enabledPlainTextPwd;

    public HtpasswdAuthOptions() {
        this.htpasswdFile = "htpasswd";
        String os = System.getProperty("os.name").toLowerCase();
        this.enabledPlainTextPwd = os.startsWith("windows") || os.startsWith("netware");
        this.usersAuthorizedForEverything = false;
    }

    public HtpasswdAuthOptions(HtpasswdAuthOptions that) {
        this.htpasswdFile = that.htpasswdFile;
        this.enabledPlainTextPwd = that.enabledPlainTextPwd;
    }

    public HtpasswdAuthOptions enablePlainTextAndDisableCryptPwd() {
        this.enabledPlainTextPwd = true;
        return this;
    }

    public HtpasswdAuthOptions enableCryptAndDisablePlainTextPwd() {
        this.enabledPlainTextPwd = false;
        return this;
    }

    public String getHtpasswdFile() {
        return this.htpasswdFile;
    }

    public void setHtpasswdFile(String htpasswdFile) {
        this.htpasswdFile = htpasswdFile;
    }

    public boolean isEnabledPlainTextPwd() {
        return this.enabledPlainTextPwd;
    }

    public boolean isEnabledCryptPwd() {
        return !this.enabledPlainTextPwd;
    }

    public AuthOptions clone() {
        return new HtpasswdAuthOptions(this);
    }

    public AuthProvider createProvider(Vertx vertx) {
        return HtpasswdAuth.create(vertx, this);
    }

    public boolean areUsersAuthorizedForEverything() {
        return this.usersAuthorizedForEverything;
    }

    public HtpasswdAuthOptions setUsersAuthorizedForEverything(boolean usersAuthorizedForEverything) {
        this.usersAuthorizedForEverything = usersAuthorizedForEverything;
        return this;
    }
}

