/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htpasswd.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.htpasswd.HtpasswdAuth;
import io.vertx.ext.auth.htpasswd.HtpasswdAuthOptions;
import io.vertx.ext.auth.htpasswd.digest.Digest;
import io.vertx.ext.auth.htpasswd.impl.HtpasswdUser;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtpasswdAuthImpl
implements HtpasswdAuth {
    private final Map<String, String> htUsers = new HashMap<String, String>();
    private HtpasswdAuthOptions htpasswdAuthOptions;

    public HtpasswdAuthImpl(Vertx vertx, HtpasswdAuthOptions htpasswdAuthOptions) {
        this.htpasswdAuthOptions = htpasswdAuthOptions;
        for (String line : vertx.fileSystem().readFileBlocking(htpasswdAuthOptions.getHtpasswdFile()).toString().split("\\r?\\n")) {
            Pattern entry;
            Matcher m;
            if ((line = line.trim()).isEmpty() || line.startsWith("#") || !(m = (entry = Pattern.compile("^([^:]+):(.+)")).matcher(line)).matches()) continue;
            this.htUsers.put(m.group(1), m.group(2));
        }
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        String username = authInfo.getString("username");
        String password = authInfo.getString("password");
        if (username == null || username.length() == 0) {
            resultHandler.handle((Object)Future.failedFuture((String)"Username must be set for authentication."));
            return;
        }
        if (!this.htUsers.containsKey(username)) {
            resultHandler.handle((Object)Future.failedFuture((String)"Unknown username."));
            return;
        }
        String storedPwd = this.htUsers.get(username);
        boolean authenticated = false;
        if (Digest.isBcryptHashed(storedPwd)) {
            if (Digest.bcryptCheck(password, storedPwd)) {
                authenticated = true;
            }
        } else if (Digest.isMd5Hashed(storedPwd)) {
            if (Digest.md5Check(password, storedPwd)) {
                authenticated = true;
            }
        } else if (Digest.isShaHashed(storedPwd)) {
            if (Digest.shaCheck(password, storedPwd)) {
                authenticated = true;
            }
        } else if (this.htpasswdAuthOptions.isEnabledCryptPwd()) {
            if (Digest.cryptCheck(password, storedPwd)) {
                authenticated = true;
            }
        } else if (this.htpasswdAuthOptions.isEnabledPlainTextPwd() && storedPwd.equals(password)) {
            authenticated = true;
        }
        if (authenticated) {
            resultHandler.handle((Object)Future.succeededFuture((Object)((Object)new HtpasswdUser(username, this.htpasswdAuthOptions.areUsersAuthorizedForEverything()))));
        } else {
            resultHandler.handle((Object)Future.failedFuture((String)"Bad response"));
        }
    }
}

