/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htpasswd.impl.hash;

import io.vertx.ext.auth.hashing.HashString;
import io.vertx.ext.auth.hashing.HashingAlgorithm;
import io.vertx.ext.auth.impl.Codec;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA1
implements HashingAlgorithm {
    private final MessageDigest md;

    public SHA1() {
        try {
            this.md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("SHA1 is not available", nsae);
        }
    }

    public String id() {
        return "{SHA}";
    }

    public String hash(HashString hashString, String password) {
        return Codec.base64Encode((byte[])this.md.digest(password.getBytes(StandardCharsets.UTF_8)));
    }

    public boolean needsSeparator() {
        return false;
    }
}

