/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jdbc;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthOptions;
import io.vertx.ext.auth.jdbc.JDBCAuth;
import io.vertx.ext.auth.jdbc.JDBCAuthOptionsConverter;
import io.vertx.ext.jdbc.JDBCClient;

@DataObject(generateConverter=true)
public class JDBCAuthOptions
implements AuthOptions {
    private boolean shared;
    private String datasourceName;
    private String authenticationQuery;
    private String rolesQuery;
    private String permissionsQuery;
    private String rolesPrefix;
    private JsonObject config;

    public JDBCAuthOptions() {
        this.shared = true;
        this.config = null;
    }

    public JDBCAuthOptions(JDBCAuthOptions that) {
        this.shared = that.shared;
        this.datasourceName = that.datasourceName;
        this.config = that.config != null ? that.config.copy() : null;
    }

    public JDBCAuthOptions(JsonObject json) {
        this();
        JDBCAuthOptionsConverter.fromJson(json, this);
    }

    public JDBCAuthOptions clone() {
        return new JDBCAuthOptions(this);
    }

    public JDBCAuth createProvider(Vertx vertx) {
        JDBCClient client = this.shared ? (this.datasourceName != null ? JDBCClient.createShared((Vertx)vertx, (JsonObject)this.config, (String)this.datasourceName) : JDBCClient.createShared((Vertx)vertx, (JsonObject)this.config)) : JDBCClient.createNonShared((Vertx)vertx, (JsonObject)this.config);
        JDBCAuth auth = JDBCAuth.create(client);
        if (this.authenticationQuery != null) {
            auth.setAuthenticationQuery(this.authenticationQuery);
        }
        if (this.rolesQuery != null) {
            auth.setRolesQuery(this.rolesQuery);
        }
        if (this.permissionsQuery != null) {
            auth.setPermissionsQuery(this.permissionsQuery);
        }
        if (this.rolesPrefix != null) {
            auth.setRolePrefix(this.rolesPrefix);
        }
        return auth;
    }

    public boolean isShared() {
        return this.shared;
    }

    public JDBCAuthOptions setShared(boolean shared) {
        this.shared = shared;
        return this;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public JDBCAuthOptions setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
        return this;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public JDBCAuthOptions setConfig(JsonObject config) {
        this.config = config;
        return this;
    }

    public String getAuthenticationQuery() {
        return this.authenticationQuery;
    }

    public JDBCAuthOptions setAuthenticationQuery(String authenticationQuery) {
        this.authenticationQuery = authenticationQuery;
        return this;
    }

    public String getRolesQuery() {
        return this.rolesQuery;
    }

    public JDBCAuthOptions setRolesQuery(String rolesQuery) {
        this.rolesQuery = rolesQuery;
        return this;
    }

    public String getPermissionsQuery() {
        return this.permissionsQuery;
    }

    public JDBCAuthOptions setPermissionsQuery(String permissionsQuery) {
        this.permissionsQuery = permissionsQuery;
        return this;
    }

    public String getRolesPrefix() {
        return this.rolesPrefix;
    }

    public JDBCAuthOptions setRolesPrefix(String rolesPrefix) {
        this.rolesPrefix = rolesPrefix;
        return this;
    }
}

