/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AbstractUser;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.jdbc.impl.JDBCAuthImpl;
import java.nio.charset.StandardCharsets;

public class JDBCUser
extends AbstractUser {
    private JDBCAuthImpl authProvider;
    private String username;
    private JsonObject principal;
    private String rolePrefix;

    public JDBCUser() {
    }

    JDBCUser(String username, JDBCAuthImpl authProvider, String rolePrefix) {
        this.username = username;
        this.authProvider = authProvider;
        this.rolePrefix = rolePrefix;
    }

    public void doIsPermitted(String permissionOrRole, Handler<AsyncResult<Boolean>> resultHandler) {
        if (permissionOrRole != null && permissionOrRole.startsWith(this.rolePrefix)) {
            this.hasRoleOrPermission(permissionOrRole.substring(this.rolePrefix.length()), this.authProvider.getRolesQuery(), resultHandler);
        } else {
            this.hasRoleOrPermission(permissionOrRole, this.authProvider.getPermissionsQuery(), resultHandler);
        }
    }

    public JsonObject principal() {
        if (this.principal == null) {
            this.principal = new JsonObject().put("username", this.username);
        }
        return this.principal;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        if (!(authProvider instanceof JDBCAuthImpl)) {
            throw new IllegalArgumentException("Not a JDBCAuthImpl");
        }
        this.authProvider = (JDBCAuthImpl)authProvider;
    }

    public void writeToBuffer(Buffer buff) {
        super.writeToBuffer(buff);
        byte[] bytes = this.username.getBytes(StandardCharsets.UTF_8);
        buff.appendInt(bytes.length);
        buff.appendBytes(bytes);
        bytes = this.rolePrefix.getBytes(StandardCharsets.UTF_8);
        buff.appendInt(bytes.length);
        buff.appendBytes(bytes);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        pos = super.readFromBuffer(pos, buffer);
        int len = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
        this.username = new String(bytes, StandardCharsets.UTF_8);
        pos += len;
        len = buffer.getInt(pos);
        bytes = buffer.getBytes(pos += 4, pos + len);
        this.rolePrefix = new String(bytes, StandardCharsets.UTF_8);
        return pos += len;
    }

    private void hasRoleOrPermission(String roleOrPermission, String query, Handler<AsyncResult<Boolean>> resultHandler) {
        this.authProvider.executeQuery(query, new JsonArray().add(this.username), resultHandler, rs -> {
            boolean has = false;
            for (JsonArray result : rs.getResults()) {
                String theRoleOrPermission = result.getString(0);
                if (!roleOrPermission.equals(theRoleOrPermission)) continue;
                resultHandler.handle((Object)Future.succeededFuture((Object)true));
                has = true;
                break;
            }
            if (!has) {
                resultHandler.handle((Object)Future.succeededFuture((Object)false));
            }
        });
    }
}

