/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jdbc;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.jdbc.JDBCHashStrategy;
import io.vertx.ext.auth.jdbc.impl.JDBCAuthImpl;
import io.vertx.ext.jdbc.JDBCClient;

@VertxGen
public interface JDBCAuth
extends AuthProvider {
    public static final String DEFAULT_AUTHENTICATE_QUERY = "SELECT PASSWORD, PASSWORD_SALT FROM USER WHERE USERNAME = ?";
    public static final String DEFAULT_ROLES_QUERY = "SELECT ROLE FROM USER_ROLES WHERE USERNAME = ?";
    public static final String DEFAULT_PERMISSIONS_QUERY = "SELECT PERM FROM ROLES_PERMS RP, USER_ROLES UR WHERE UR.USERNAME = ? AND UR.ROLE = RP.ROLE";
    public static final String DEFAULT_ROLE_PREFIX = "role:";

    public static JDBCAuth create(Vertx vertx, JDBCClient client) {
        return new JDBCAuthImpl(vertx, client);
    }

    @Fluent
    public JDBCAuth setAuthenticationQuery(String var1);

    @Fluent
    public JDBCAuth setRolesQuery(String var1);

    @Fluent
    public JDBCAuth setPermissionsQuery(String var1);

    @Fluent
    public JDBCAuth setRolePrefix(String var1);

    @GenIgnore
    public JDBCAuth setHashStrategy(JDBCHashStrategy var1);

    default public String computeHash(String password, String salt) {
        return this.computeHash(password, salt, -1);
    }

    public String computeHash(String var1, String var2, int var3);

    public String generateSalt();

    @Fluent
    public JDBCAuth setNonces(JsonArray var1);
}

