/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jdbc.JDBCAuth;
import io.vertx.ext.auth.jdbc.JDBCHashStrategy;
import io.vertx.ext.auth.jdbc.impl.JDBCUser;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import java.util.function.Consumer;

public class JDBCAuthImpl
implements AuthProvider,
JDBCAuth {
    private JDBCClient client;
    private String authenticateQuery = "SELECT PASSWORD, PASSWORD_SALT FROM USER WHERE USERNAME = ?";
    private String rolesQuery = "SELECT ROLE FROM USER_ROLES WHERE USERNAME = ?";
    private String permissionsQuery = "SELECT PERM FROM ROLES_PERMS RP, USER_ROLES UR WHERE UR.USERNAME = ? AND UR.ROLE = RP.ROLE";
    private String rolePrefix = "role:";
    private JDBCHashStrategy strategy;

    public JDBCAuthImpl(Vertx vertx, JDBCClient client) {
        this.client = client;
        this.strategy = JDBCHashStrategy.createSHA512(vertx);
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        String username = authInfo.getString("username");
        if (username == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"authInfo must contain username in 'username' field"));
            return;
        }
        String password = authInfo.getString("password");
        if (password == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"authInfo must contain password in 'password' field"));
            return;
        }
        this.executeQuery(this.authenticateQuery, new JsonArray().add(username), resultHandler, rs -> {
            switch (rs.getNumRows()) {
                case 0: {
                    resultHandler.handle((Object)Future.failedFuture((String)"Invalid username/password"));
                    break;
                }
                case 1: {
                    String hashedPassword;
                    JsonArray row = (JsonArray)rs.getResults().get(0);
                    String hashedStoredPwd = this.strategy.getHashedStoredPwd(row);
                    String salt = this.strategy.getSalt(row);
                    int version = -1;
                    int sep = hashedStoredPwd.lastIndexOf(36);
                    if (sep != -1) {
                        try {
                            version = Integer.parseInt(hashedStoredPwd.substring(sep + 1));
                        }
                        catch (NumberFormatException e) {
                            resultHandler.handle((Object)Future.failedFuture((String)("Invalid nonce version: " + version)));
                            return;
                        }
                    }
                    if (JDBCHashStrategy.isEqual(hashedStoredPwd, hashedPassword = this.strategy.computeHash(password, salt, version))) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)((Object)new JDBCUser(username, this, this.rolePrefix))));
                        break;
                    }
                    resultHandler.handle((Object)Future.failedFuture((String)"Invalid username/password"));
                    break;
                }
                default: {
                    resultHandler.handle((Object)Future.failedFuture((String)"Failure in authentication"));
                }
            }
        });
    }

    @Override
    public JDBCAuth setAuthenticationQuery(String authenticationQuery) {
        this.authenticateQuery = authenticationQuery;
        return this;
    }

    @Override
    public JDBCAuth setRolesQuery(String rolesQuery) {
        this.rolesQuery = rolesQuery;
        return this;
    }

    @Override
    public JDBCAuth setPermissionsQuery(String permissionsQuery) {
        this.permissionsQuery = permissionsQuery;
        return this;
    }

    @Override
    public JDBCAuth setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
        return this;
    }

    @Override
    public JDBCAuth setHashStrategy(JDBCHashStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    <T> void executeQuery(String query, JsonArray params, Handler<AsyncResult<T>> resultHandler, Consumer<ResultSet> resultSetConsumer) {
        this.client.getConnection(res -> {
            if (res.succeeded()) {
                SQLConnection conn = (SQLConnection)res.result();
                conn.queryWithParams(query, params, queryRes -> {
                    if (queryRes.succeeded()) {
                        ResultSet rs = (ResultSet)queryRes.result();
                        resultSetConsumer.accept(rs);
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)queryRes.cause()));
                    }
                    conn.close(closeRes -> {});
                });
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    @Override
    public String computeHash(String password, String salt, int version) {
        return this.strategy.computeHash(password, salt, version);
    }

    @Override
    public String generateSalt() {
        return this.strategy.generateSalt();
    }

    @Override
    public JDBCAuth setNonces(JsonArray nonces) {
        this.strategy.setNonces(nonces);
        return this;
    }

    String getRolesQuery() {
        return this.rolesQuery;
    }

    String getPermissionsQuery() {
        return this.permissionsQuery;
    }
}

