/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.jdbc.JDBCAuth;
import io.vertx.ext.auth.jdbc.JDBCAuthentication;
import io.vertx.ext.auth.jdbc.JDBCAuthenticationOptions;
import io.vertx.ext.auth.jdbc.JDBCAuthorization;
import io.vertx.ext.auth.jdbc.JDBCAuthorizationOptions;
import io.vertx.ext.auth.jdbc.JDBCHashStrategy;
import io.vertx.ext.jdbc.JDBCClient;
import java.util.Objects;

public class JDBCAuthImpl
implements AuthProvider,
JDBCAuth {
    private final JDBCClient client;
    private JDBCAuthentication authenticationProvider;
    private final JDBCAuthenticationOptions authenticationOptions;
    private final JDBCAuthorization authorizationProvider;
    private final JDBCAuthorizationOptions authorizationOptions;
    private JDBCHashStrategy hashStrategy;

    public JDBCAuthImpl(Vertx vertx, JDBCClient client) {
        this.client = client;
        this.hashStrategy = JDBCHashStrategy.createSHA512(vertx);
        this.authenticationOptions = new JDBCAuthenticationOptions();
        this.authorizationOptions = new JDBCAuthorizationOptions();
        this.authenticationProvider = JDBCAuthentication.create(client, this.hashStrategy, this.authenticationOptions);
        this.authorizationProvider = JDBCAuthorization.create("jdbc-auth", client, this.authorizationOptions);
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate((Credentials)new UsernamePasswordCredentials(authInfo), resultHandler);
    }

    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> resultHandler) {
        try {
            UsernamePasswordCredentials authInfo = (UsernamePasswordCredentials)credentials;
            authInfo.checkValid(null);
            this.authenticationProvider.authenticate(credentials, authenticationResult -> {
                if (authenticationResult.failed()) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)authenticationResult.cause()));
                } else {
                    User user = (User)authenticationResult.result();
                    this.authorizationProvider.getAuthorizations(user, userAuthorizationResult -> {
                        if (userAuthorizationResult.failed()) {
                            resultHandler.handle((Object)Future.failedFuture((Throwable)userAuthorizationResult.cause()));
                        } else {
                            resultHandler.handle((Object)Future.succeededFuture((Object)user));
                        }
                    });
                }
            });
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    @Override
    public JDBCAuth setAuthenticationQuery(String authenticationQuery) {
        this.authenticationOptions.setAuthenticationQuery(authenticationQuery);
        return this;
    }

    @Override
    public JDBCAuth setRolesQuery(String rolesQuery) {
        this.authorizationOptions.setRolesQuery(rolesQuery);
        return this;
    }

    @Override
    public JDBCAuth setPermissionsQuery(String permissionsQuery) {
        this.authorizationOptions.setPermissionsQuery(permissionsQuery);
        return this;
    }

    @Override
    public JDBCAuth setRolePrefix(String rolePrefix) {
        return this;
    }

    @Override
    public JDBCAuth setHashStrategy(JDBCHashStrategy strategy) {
        this.hashStrategy = Objects.requireNonNull(strategy);
        this.authenticationProvider = JDBCAuthentication.create(this.client, strategy, this.authenticationOptions);
        return this;
    }

    @Override
    public String computeHash(String password, String salt, int version) {
        return this.hashStrategy.computeHash(password, salt, version);
    }

    @Override
    public String generateSalt() {
        return this.hashStrategy.generateSalt();
    }

    @Override
    public JDBCAuth setNonces(JsonArray nonces) {
        this.hashStrategy.setNonces(nonces);
        return this;
    }

    String getRolesQuery() {
        return this.authorizationOptions.getRolesQuery();
    }

    String getPermissionsQuery() {
        return this.authorizationOptions.getPermissionsQuery();
    }
}

