/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.jdbc.JDBCAuthorization;
import io.vertx.ext.auth.jdbc.JDBCAuthorizationOptions;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@Deprecated
public class JDBCAuthorizationImpl
implements JDBCAuthorization {
    private static final String DEFAULT_USERNAME_KEY = "username";
    private final String providerId;
    private final JDBCAuthorizationOptions options;
    private final JDBCClient client;
    private final String usernameKey;

    public JDBCAuthorizationImpl(String providerId, JDBCClient client, JDBCAuthorizationOptions options) {
        this.providerId = Objects.requireNonNull(providerId);
        this.client = Objects.requireNonNull(client);
        this.options = Objects.requireNonNull(options);
        this.usernameKey = DEFAULT_USERNAME_KEY;
    }

    public String getId() {
        return this.providerId;
    }

    private void getRoles(SQLConnection sqlConnection, JsonArray params, Handler<AsyncResult<Set<Authorization>>> resultHandler) {
        if (this.options.getRolesQuery() != null) {
            sqlConnection.queryWithParams(this.options.getRolesQuery(), params, queryResponse -> {
                if (queryResponse.succeeded()) {
                    HashSet<RoleBasedAuthorization> authorizations = new HashSet<RoleBasedAuthorization>();
                    ResultSet resultSet = (ResultSet)queryResponse.result();
                    for (JsonArray result : resultSet.getResults()) {
                        String role = result.getString(0);
                        authorizations.add(RoleBasedAuthorization.create((String)role));
                    }
                    resultHandler.handle((Object)Future.succeededFuture(authorizations));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)queryResponse.cause()));
                }
            });
        } else {
            resultHandler.handle((Object)Future.succeededFuture(Collections.emptySet()));
        }
    }

    private void getPermissions(SQLConnection sqlConnection, JsonArray params, Handler<AsyncResult<Set<Authorization>>> resultHandler) {
        if (this.options.getPermissionsQuery() != null) {
            sqlConnection.queryWithParams(this.options.getPermissionsQuery(), params, queryResponse -> {
                if (queryResponse.succeeded()) {
                    HashSet<PermissionBasedAuthorization> authorizations = new HashSet<PermissionBasedAuthorization>();
                    ResultSet resultSet = (ResultSet)queryResponse.result();
                    for (JsonArray result : resultSet.getResults()) {
                        String permission = result.getString(0);
                        authorizations.add(PermissionBasedAuthorization.create((String)permission));
                    }
                    resultHandler.handle((Object)Future.succeededFuture(authorizations));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)queryResponse.cause()));
                }
            });
        } else {
            resultHandler.handle((Object)Future.succeededFuture(Collections.emptySet()));
        }
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Void>> resultHandler) {
        this.client.getConnection(connectionResponse -> {
            if (connectionResponse.succeeded()) {
                String username = user.principal().getString(this.usernameKey);
                if (username != null) {
                    JsonArray params = new JsonArray().add((Object)username);
                    SQLConnection connection = (SQLConnection)connectionResponse.result();
                    this.getRoles(connection, params, (Handler<AsyncResult<Set<Authorization>>>)((Handler)roleResponse -> {
                        if (roleResponse.succeeded()) {
                            HashSet authorizations = new HashSet((Collection)roleResponse.result());
                            this.getPermissions(connection, params, (Handler<AsyncResult<Set<Authorization>>>)((Handler)permissionResponse -> {
                                if (permissionResponse.succeeded()) {
                                    authorizations.addAll((Collection)permissionResponse.result());
                                    user.authorizations().add(this.getId(), authorizations);
                                    resultHandler.handle((Object)Future.succeededFuture());
                                } else {
                                    resultHandler.handle((Object)Future.failedFuture((Throwable)permissionResponse.cause()));
                                }
                                connection.close();
                            }));
                        } else {
                            resultHandler.handle((Object)Future.failedFuture((Throwable)roleResponse.cause()));
                            connection.close();
                        }
                    }));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((String)"Couldn't get the username"));
                    ((SQLConnection)connectionResponse.result()).close();
                }
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)connectionResponse.cause()));
            }
        });
    }
}

