/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.auth.HashingStrategy;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.jdbc.JDBCUserUtil;
import io.vertx.ext.jdbc.JDBCClient;
import java.security.SecureRandom;

@Deprecated
public class JDBCUserUtilImpl
implements JDBCUserUtil {
    private static final String INSERT_USER = "INSERT INTO user (username, password) VALUES (?, ?)";
    private static final String INSERT_USER_ROLE = "INSERT INTO user_roles (username, role) VALUES (?, ?)";
    private static final String INSERT_ROLE_PERMISSION = "INSERT INTO roles_perms (role, permission) VALUES (?, ?)";
    private final JDBCClient client;
    private final HashingStrategy strategy = HashingStrategy.load();
    private final SecureRandom random = new SecureRandom();
    private final String insertUser;
    private final String insertUserRole;
    private final String insertRolePermission;

    public JDBCUserUtilImpl(JDBCClient client) {
        this(client, INSERT_USER, INSERT_USER_ROLE, INSERT_ROLE_PERMISSION);
    }

    public JDBCUserUtilImpl(JDBCClient client, String insertUser, String insertUserRole, String insertRolePermission) {
        this.client = client;
        this.insertUser = insertUser;
        this.insertUserRole = insertUserRole;
        this.insertRolePermission = insertRolePermission;
    }

    @Override
    public JDBCUserUtil createUser(String username, String password, Handler<AsyncResult<Void>> resultHandler) {
        if (username == null || password == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"username or password are null"));
            return this;
        }
        byte[] salt = new byte[32];
        this.random.nextBytes(salt);
        return this.createHashedUser(username, this.strategy.hash("pbkdf2", null, Codec.base64Encode((byte[])salt), password), resultHandler);
    }

    @Override
    public JDBCUserUtil createHashedUser(String username, String hash, Handler<AsyncResult<Void>> resultHandler) {
        if (username == null || hash == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"username or password hash are null"));
            return this;
        }
        this.client.updateWithParams(this.insertUser, new JsonArray().add((Object)username).add((Object)hash), insert -> {
            if (insert.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)insert.cause()));
            }
        });
        return this;
    }

    @Override
    public JDBCUserUtil createUserRole(String username, String role, Handler<AsyncResult<Void>> resultHandler) {
        if (username == null || role == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"username or role are null"));
            return this;
        }
        this.client.updateWithParams(this.insertUserRole, new JsonArray().add((Object)username).add((Object)role), insert -> {
            if (insert.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)insert.cause()));
            }
        });
        return this;
    }

    @Override
    public JDBCUserUtil createRolePermission(String role, String permission, Handler<AsyncResult<Void>> resultHandler) {
        if (role == null || permission == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"role or permission are null"));
            return this;
        }
        this.client.updateWithParams(this.insertRolePermission, new JsonArray().add((Object)role).add((Object)permission), insert -> {
            if (insert.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)insert.cause()));
            }
        });
        return this;
    }
}

