/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.HashingStrategy;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.jdbc.JDBCAuthentication;
import io.vertx.ext.auth.jdbc.JDBCAuthenticationOptions;
import io.vertx.ext.auth.jdbc.JDBCHashStrategy;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@Deprecated
public class JDBCAuthenticationImpl
implements JDBCAuthentication {
    private final HashingStrategy strategy = HashingStrategy.load();
    private final JDBCClient client;
    private JDBCHashStrategy legacyStrategy;
    private final JDBCAuthenticationOptions options;

    public JDBCAuthenticationImpl(JDBCClient client, JDBCHashStrategy hashStrategy, JDBCAuthenticationOptions options) {
        this.client = Objects.requireNonNull(client);
        this.options = Objects.requireNonNull(options);
        this.legacyStrategy = Objects.requireNonNull(hashStrategy);
    }

    public JDBCAuthenticationImpl(JDBCClient client, JDBCAuthenticationOptions options) {
        this.client = Objects.requireNonNull(client);
        this.options = Objects.requireNonNull(options);
    }

    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate(credentials).onComplete(resultHandler);
    }

    public Future<User> authenticate(JsonObject authInfo) {
        return this.authenticate((Credentials)new UsernamePasswordCredentials(authInfo));
    }

    public Future<User> authenticate(Credentials credentials) {
        UsernamePasswordCredentials authInfo;
        try {
            authInfo = (UsernamePasswordCredentials)credentials;
            authInfo.checkValid(null);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
        Promise promise = Promise.promise();
        this.executeQuery(this.options.getAuthenticationQuery(), new JsonArray().add((Object)authInfo.getUsername()), (Handler<AsyncResult<ResultSet>>)((Handler)queryResponse -> {
            if (queryResponse.succeeded()) {
                ResultSet rs = (ResultSet)queryResponse.result();
                switch (rs.getNumRows()) {
                    case 0: {
                        promise.fail("Invalid username/password");
                        break;
                    }
                    case 1: {
                        JsonArray row = (JsonArray)rs.getResults().get(0);
                        try {
                            if (this.verify(row, authInfo.getPassword())) {
                                User user = User.fromName((String)authInfo.getUsername());
                                user.principal().put("amr", Collections.singletonList("pwd"));
                                promise.complete((Object)user);
                                break;
                            }
                            promise.fail("Invalid username/password");
                        }
                        catch (RuntimeException e) {
                            promise.fail((Throwable)e);
                        }
                        break;
                    }
                    default: {
                        promise.fail("Failure in authentication");
                    }
                }
            } else {
                promise.fail(queryResponse.cause());
            }
        }));
        return promise.future();
    }

    private boolean verify(JsonArray row, String password) {
        String hash = row.getString(0);
        if (hash.charAt(0) != '$') {
            if (this.legacyStrategy == null) {
                throw new IllegalStateException("JDBC Authentication cannot handle legacy hashes without a JDBCStrategy");
            }
            String salt = row.getString(1);
            int version = -1;
            int sep = hash.lastIndexOf(36);
            if (sep != -1) {
                try {
                    version = Integer.parseInt(hash.substring(sep + 1));
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid nonce version: " + version);
                }
            }
            return JDBCHashStrategy.isEqual(hash, this.legacyStrategy.computeHash(password, salt, version));
        }
        return this.strategy.verify(hash, password);
    }

    void executeQuery(String query, JsonArray params, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.client.getConnection(res -> {
            if (res.succeeded()) {
                SQLConnection connection = (SQLConnection)res.result();
                connection.queryWithParams(query, params, queryResponse -> {
                    resultHandler.handle(queryResponse);
                    connection.close();
                });
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    @Override
    public String hash(String id, Map<String, String> params, String salt, String password) {
        return this.strategy.hash(id, params, salt, password);
    }
}

