/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.ext.auth.jwt.impl.Crypto;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;

final class CryptoSignature
implements Crypto {
    private final Signature sig;
    private final PrivateKey privateKey;
    private final X509Certificate certificate;

    CryptoSignature(X509Certificate certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.privateKey = privateKey;
        try {
            this.sig = Signature.getInstance(certificate.getSigAlgName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] sign(byte[] payload) {
        try {
            this.sig.initSign(this.privateKey);
            this.sig.update(payload);
            return this.sig.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean verify(byte[] signature, byte[] payload) {
        try {
            this.sig.initVerify(this.certificate);
            this.sig.update(payload);
            return this.sig.verify(signature);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }
}

