/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.ldap.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.ldap.LdapAuthentication;
import io.vertx.ext.auth.ldap.LdapAuthenticationOptions;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Objects;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LdapAuthenticationImpl
implements LdapAuthentication {
    private static final String SIMPLE_AUTHENTICATION_MECHANISM = "simple";
    private static final String FOLLOW_REFERRAL = "follow";
    private final Vertx vertx;
    private final LdapAuthenticationOptions authenticationOptions;

    public LdapAuthenticationImpl(Vertx vertx, LdapAuthenticationOptions authenticationOptions) {
        this.vertx = Objects.requireNonNull(vertx);
        this.authenticationOptions = Objects.requireNonNull(authenticationOptions);
    }

    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate(credentials).onComplete(resultHandler);
    }

    public Future<User> authenticate(JsonObject credentials) {
        return this.authenticate((Credentials)new UsernamePasswordCredentials(credentials));
    }

    public Future<User> authenticate(Credentials credentials) {
        UsernamePasswordCredentials authInfo;
        try {
            authInfo = (UsernamePasswordCredentials)credentials;
            authInfo.checkValid(null);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
        String ldapPrincipal = this.getLdapPrincipal(authInfo.getUsername());
        return this.createLdapContext(ldapPrincipal, authInfo.getPassword()).compose(ldapContext -> {
            User user = User.fromName((String)authInfo.getUsername());
            user.principal().put("amr", Collections.singletonList("pwd"));
            return Future.succeededFuture((Object)user);
        });
    }

    private Future<LdapContext> createLdapContext(String principal, String credential) {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.provider.url", this.authenticationOptions.getUrl());
        if (principal != null) {
            environment.put("java.naming.security.principal", principal);
        }
        if (credential != null) {
            environment.put("java.naming.security.credentials", credential);
        }
        if (this.authenticationOptions.getAuthenticationMechanism() == null && (principal != null || credential != null)) {
            environment.put("java.naming.security.authentication", SIMPLE_AUTHENTICATION_MECHANISM);
        }
        environment.put("java.naming.referral", this.authenticationOptions.getReferral() == null ? FOLLOW_REFERRAL : this.authenticationOptions.getReferral());
        PromiseInternal promise = ((VertxInternal)this.vertx).promise();
        this.vertx.executeBlocking(blockingResult -> {
            try {
                InitialLdapContext context = new InitialLdapContext(environment, null);
                blockingResult.complete((Object)context);
            }
            catch (Throwable t) {
                blockingResult.fail(t);
            }
        }, (Handler)promise);
        return promise.future();
    }

    private String getLdapPrincipal(String principal) {
        return this.authenticationOptions.getAuthenticationQuery().replace("{0}", principal);
    }
}

