/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.mongo.HashSaltStyle;
import io.vertx.ext.auth.mongo.MongoAuthOptions;
import java.util.Map;

public class MongoAuthOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, MongoAuthOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "collectionName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCollectionName((String)member.getValue());
                    break;
                }
                case "config": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setConfig(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "datasourceName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDatasourceName((String)member.getValue());
                    break;
                }
                case "passwordField": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPasswordField((String)member.getValue());
                    break;
                }
                case "permissionField": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPermissionField((String)member.getValue());
                    break;
                }
                case "roleField": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRoleField((String)member.getValue());
                    break;
                }
                case "saltField": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSaltField((String)member.getValue());
                    break;
                }
                case "saltStyle": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSaltStyle(HashSaltStyle.valueOf((String)member.getValue()));
                    break;
                }
                case "shared": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setShared((Boolean)member.getValue());
                    break;
                }
                case "usernameCredentialField": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUsernameCredentialField((String)member.getValue());
                    break;
                }
                case "usernameField": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUsernameField((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(MongoAuthOptions obj, JsonObject json) {
        MongoAuthOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(MongoAuthOptions obj, Map<String, Object> json) {
        if (obj.getCollectionName() != null) {
            json.put("collectionName", obj.getCollectionName());
        }
        if (obj.getConfig() != null) {
            json.put("config", obj.getConfig());
        }
        if (obj.getDatasourceName() != null) {
            json.put("datasourceName", obj.getDatasourceName());
        }
        if (obj.getPasswordField() != null) {
            json.put("passwordField", obj.getPasswordField());
        }
        if (obj.getPermissionField() != null) {
            json.put("permissionField", obj.getPermissionField());
        }
        if (obj.getRoleField() != null) {
            json.put("roleField", obj.getRoleField());
        }
        if (obj.getSaltField() != null) {
            json.put("saltField", obj.getSaltField());
        }
        if (obj.getSaltStyle() != null) {
            json.put("saltStyle", obj.getSaltStyle().name());
        }
        json.put("shared", obj.getShared());
        if (obj.getUsernameCredentialField() != null) {
            json.put("usernameCredentialField", obj.getUsernameCredentialField());
        }
        if (obj.getUsernameField() != null) {
            json.put("usernameField", obj.getUsernameField());
        }
    }
}

