/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AbstractUser;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.mongo.MongoAuth;

public class MongoUser
extends AbstractUser {
    private JsonObject principal;
    private MongoAuth mongoAuth;

    public MongoUser() {
    }

    public MongoUser(String username, MongoAuth mongoAuth) {
        this.principal = new JsonObject().put(mongoAuth.getUsernameField(), username);
        this.mongoAuth = mongoAuth;
    }

    public MongoUser(JsonObject principal, MongoAuth mongoAuth) {
        this.principal = principal;
        this.mongoAuth = mongoAuth;
    }

    public void doIsPermitted(String permissionOrRole, Handler<AsyncResult<Boolean>> resultHandler) {
        if (permissionOrRole != null && permissionOrRole.startsWith("role:")) {
            String roledef = permissionOrRole.substring("role:".length());
            this.doHasRole(roledef, resultHandler);
        } else {
            this.doHasPermission(permissionOrRole, resultHandler);
        }
    }

    public JsonObject principal() {
        return this.principal;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.mongoAuth = (MongoAuth)authProvider;
    }

    protected void doHasRole(String role, Handler<AsyncResult<Boolean>> resultHandler) {
        try {
            JsonArray roles = this.principal.getJsonArray(this.mongoAuth.getRoleField());
            resultHandler.handle((Object)Future.succeededFuture((Object)(roles != null && roles.contains((Object)role) ? 1 : 0)));
        }
        catch (Throwable e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public String getSalt() {
        return this.principal.getString(this.mongoAuth.getSaltField());
    }

    public String getPassword() {
        return this.principal.getString(this.mongoAuth.getPasswordField());
    }

    protected void doHasPermission(String permission, Handler<AsyncResult<Boolean>> resultHandler) {
        try {
            JsonArray userPermissions = this.principal.getJsonArray(this.mongoAuth.getPermissionField());
            resultHandler.handle((Object)Future.succeededFuture((Object)(userPermissions != null && userPermissions.contains((Object)permission) ? 1 : 0)));
        }
        catch (Throwable e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public String toString() {
        return this.principal.toString();
    }
}

