/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.mongo.HashAlgorithm;
import io.vertx.ext.auth.mongo.HashStrategy;
import io.vertx.ext.auth.mongo.impl.MongoAuthImpl;
import io.vertx.ext.mongo.MongoClient;
import java.util.List;

@VertxGen
public interface MongoAuth
extends AuthProvider {
    public static final String PROPERTY_COLLECTION_NAME = "collectionName";
    public static final String PROPERTY_USERNAME_FIELD = "usernameField";
    public static final String PROPERTY_ROLE_FIELD = "roleField";
    public static final String PROPERTY_PERMISSION_FIELD = "permissionField";
    public static final String PROPERTY_PASSWORD_FIELD = "passwordField";
    public static final String PROPERTY_CREDENTIAL_USERNAME_FIELD = "usernameCredentialField";
    public static final String PROPERTY_CREDENTIAL_PASSWORD_FIELD = "passwordCredentialField";
    public static final String PROPERTY_SALT_FIELD = "saltField";
    public static final String PROPERTY_SALT_STYLE = "saltStyle";
    public static final String DEFAULT_COLLECTION_NAME = "user";
    public static final String DEFAULT_USERNAME_FIELD = "username";
    public static final String DEFAULT_PASSWORD_FIELD = "password";
    public static final String DEFAULT_ROLE_FIELD = "roles";
    public static final String DEFAULT_PERMISSION_FIELD = "permissions";
    public static final String DEFAULT_CREDENTIAL_USERNAME_FIELD = "username";
    public static final String DEFAULT_CREDENTIAL_PASSWORD_FIELD = "password";
    public static final String DEFAULT_SALT_FIELD = "salt";
    public static final String ROLE_PREFIX = "role:";

    public static MongoAuth create(MongoClient mongoClient, JsonObject config) {
        return new MongoAuthImpl(mongoClient, config);
    }

    @Fluent
    public MongoAuth setCollectionName(String var1);

    @Fluent
    public MongoAuth setUsernameField(String var1);

    @Fluent
    public MongoAuth setPasswordField(String var1);

    @Fluent
    public MongoAuth setRoleField(String var1);

    @Fluent
    public MongoAuth setPermissionField(String var1);

    @Fluent
    public MongoAuth setUsernameCredentialField(String var1);

    @Fluent
    public MongoAuth setPasswordCredentialField(String var1);

    @Fluent
    public MongoAuth setSaltField(String var1);

    public String getCollectionName();

    public String getUsernameField();

    public String getPasswordField();

    public String getRoleField();

    public String getPermissionField();

    public String getUsernameCredentialField();

    public String getPasswordCredentialField();

    public String getSaltField();

    @Fluent
    public MongoAuth setHashStrategy(HashStrategy var1);

    public HashStrategy getHashStrategy();

    @Fluent
    public MongoAuth setHashAlgorithm(HashAlgorithm var1);

    public void insertUser(String var1, String var2, List<String> var3, List<String> var4, Handler<AsyncResult<String>> var5);

    default public Future<String> insertUser(String username, String password, List<String> roles, List<String> permissions) {
        Promise promise = Promise.promise();
        this.insertUser(username, password, roles, permissions, (Handler<AsyncResult<String>>)promise);
        return promise.future();
    }
}

