/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.mongo.HashAlgorithm;
import io.vertx.ext.auth.mongo.HashSaltStyle;
import io.vertx.ext.auth.mongo.HashStrategy;
import io.vertx.ext.auth.mongo.MongoAuth;
import io.vertx.ext.auth.mongo.MongoAuthentication;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import io.vertx.ext.auth.mongo.MongoAuthorization;
import io.vertx.ext.auth.mongo.MongoAuthorizationOptions;
import io.vertx.ext.auth.mongo.impl.DefaultHashStrategy;
import io.vertx.ext.mongo.MongoClient;
import java.util.Collections;
import java.util.List;

@Deprecated
public class MongoAuthImpl
implements MongoAuth {
    static final String PROPERTY_FIELD_SALT = "__field-salt__";
    static final String PROPERTY_FIELD_PASSWORD = "__field-password__";
    private static final Logger log = LoggerFactory.getLogger(MongoAuthImpl.class);
    private static final String PROVIDER_ID = "mongo-authentication";
    private final MongoClient mongoClient;
    private String saltField = "salt";
    private final MongoAuthentication mongoAuthentication;
    private final MongoAuthenticationOptions mongoAuthenticationOptions;
    private final MongoAuthorization mongoAuthorization;
    private final MongoAuthorizationOptions mongoAuthorizationOptions;
    private final JsonObject config;
    private HashStrategy hashStrategy;

    public MongoAuthImpl(MongoClient mongoClient, JsonObject config) {
        this.mongoClient = mongoClient;
        this.config = config;
        this.mongoAuthenticationOptions = new MongoAuthenticationOptions();
        this.mongoAuthorizationOptions = new MongoAuthorizationOptions();
        this.init();
        this.mongoAuthentication = MongoAuthentication.create(mongoClient, this.getHashStrategy(), this.mongoAuthenticationOptions);
        this.mongoAuthorization = MongoAuthorization.create(PROVIDER_ID, mongoClient, this.mongoAuthorizationOptions);
    }

    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate(credentials).onComplete(resultHandler);
    }

    public Future<User> authenticate(JsonObject credentials) {
        return this.authenticate((Credentials)new UsernamePasswordCredentials(credentials));
    }

    public Future<User> authenticate(Credentials credentials) {
        Promise promise = Promise.promise();
        try {
            UsernamePasswordCredentials authInfo = (UsernamePasswordCredentials)credentials;
            authInfo.checkValid(null);
            this.mongoAuthentication.authenticate((Credentials)authInfo, authenticationResult -> {
                if (authenticationResult.failed()) {
                    promise.fail(authenticationResult.cause());
                } else {
                    User user = (User)authenticationResult.result();
                    this.mongoAuthorization.getAuthorizations(user, userAuthorizationResult -> {
                        if (userAuthorizationResult.failed()) {
                            promise.fail(userAuthorizationResult.cause());
                        } else {
                            promise.complete((Object)user);
                        }
                    });
                }
            });
        }
        catch (RuntimeException e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    @Override
    public Future<String> insertUser(String username, String password, List<String> roles, List<String> permissions) {
        JsonObject principal = new JsonObject();
        principal.put(this.getUsernameField(), (Object)username);
        if (roles != null) {
            principal.put(this.mongoAuthorizationOptions.getRoleField(), (Object)new JsonArray(roles));
        }
        if (permissions != null) {
            principal.put(this.mongoAuthorizationOptions.getPermissionField(), (Object)new JsonArray(permissions));
        }
        if (this.getHashStrategy().getSaltStyle() == HashSaltStyle.COLUMN) {
            principal.put(this.getSaltField(), (Object)DefaultHashStrategy.generateSalt());
        }
        User user = this.createUser(principal);
        String cryptPassword = this.getHashStrategy().computeHash(password, user);
        principal.put(this.getPasswordField(), (Object)cryptPassword);
        return this.mongoClient.save(this.getCollectionName(), user.principal());
    }

    private User createUser(JsonObject json) {
        JsonArray permissions;
        User user = User.create((JsonObject)json);
        user.principal().put("amr", Collections.singletonList("pwd"));
        json.put(PROPERTY_FIELD_SALT, (Object)this.getSaltField());
        json.put(PROPERTY_FIELD_PASSWORD, (Object)this.getPasswordField());
        JsonArray roles = json.getJsonArray(this.mongoAuthorizationOptions.getRoleField());
        if (roles != null) {
            for (int i = 0; i < roles.size(); ++i) {
                String role = roles.getString(i);
                user.authorizations().add(PROVIDER_ID, (Authorization)RoleBasedAuthorization.create((String)role));
            }
        }
        if ((permissions = json.getJsonArray(this.mongoAuthorizationOptions.getPermissionField())) != null) {
            for (int i = 0; i < permissions.size(); ++i) {
                String permission = permissions.getString(i);
                user.authorizations().add(PROVIDER_ID, (Authorization)PermissionBasedAuthorization.create((String)permission));
            }
        }
        user.setAuthProvider((AuthProvider)this);
        return user;
    }

    private void init() {
        String saltstyle;
        String saltField;
        String passwordCredField;
        String usernameCredField;
        String permissionField;
        String roleField;
        String passwordField;
        String usernameField;
        String collectionName = this.config.getString("collectionName");
        if (collectionName != null) {
            this.setCollectionName(collectionName);
        }
        if ((usernameField = this.config.getString("usernameField")) != null) {
            this.setUsernameField(usernameField);
        }
        if ((passwordField = this.config.getString("passwordField")) != null) {
            this.setPasswordField(passwordField);
        }
        if ((roleField = this.config.getString("roleField")) != null) {
            this.setRoleField(roleField);
        }
        if ((permissionField = this.config.getString("permissionField")) != null) {
            this.setPermissionField(permissionField);
        }
        if ((usernameCredField = this.config.getString("usernameCredentialField")) != null) {
            this.setUsernameCredentialField(usernameCredField);
        }
        if ((passwordCredField = this.config.getString("passwordCredentialField")) != null) {
            this.setPasswordCredentialField(passwordCredField);
        }
        if ((saltField = this.config.getString("saltField")) != null) {
            this.setSaltField(saltField);
        }
        if ((saltstyle = this.config.getString("saltStyle")) != null) {
            this.getHashStrategy().setSaltStyle(HashSaltStyle.valueOf(saltstyle));
        }
    }

    @Override
    public MongoAuth setCollectionName(String collectionName) {
        this.mongoAuthenticationOptions.setCollectionName(collectionName);
        this.mongoAuthorizationOptions.setCollectionName(collectionName);
        return this;
    }

    @Override
    public MongoAuth setUsernameField(String fieldName) {
        this.mongoAuthenticationOptions.setUsernameField(fieldName);
        this.mongoAuthorizationOptions.setUsernameField(fieldName);
        return this;
    }

    @Override
    public MongoAuth setPasswordField(String fieldName) {
        this.mongoAuthenticationOptions.setPasswordField(fieldName);
        return this;
    }

    @Override
    public MongoAuth setRoleField(String fieldName) {
        this.mongoAuthorizationOptions.setRoleField(fieldName);
        return this;
    }

    @Override
    public MongoAuth setUsernameCredentialField(String fieldName) {
        this.mongoAuthenticationOptions.setUsernameCredentialField(fieldName);
        return this;
    }

    @Override
    public MongoAuth setPasswordCredentialField(String fieldName) {
        this.mongoAuthenticationOptions.setPasswordCredentialField(fieldName);
        return this;
    }

    @Override
    public MongoAuth setSaltField(String fieldName) {
        this.saltField = fieldName;
        return this;
    }

    @Override
    public String getCollectionName() {
        return this.mongoAuthenticationOptions.getCollectionName();
    }

    @Override
    public final String getUsernameField() {
        return this.mongoAuthenticationOptions.getUsernameField();
    }

    @Override
    public final String getPasswordField() {
        return this.mongoAuthenticationOptions.getPasswordField();
    }

    @Override
    public final String getRoleField() {
        return this.mongoAuthorizationOptions.getRoleField();
    }

    @Override
    public final String getUsernameCredentialField() {
        return this.mongoAuthenticationOptions.getUsernameCredentialField();
    }

    @Override
    public final String getPasswordCredentialField() {
        return this.mongoAuthenticationOptions.getPasswordCredentialField();
    }

    @Override
    public final String getSaltField() {
        return this.saltField;
    }

    @Override
    public MongoAuth setPermissionField(String fieldName) {
        this.mongoAuthorizationOptions.setPermissionField(fieldName);
        return this;
    }

    @Override
    public String getPermissionField() {
        return this.mongoAuthorizationOptions.getPermissionField();
    }

    @Override
    public MongoAuth setHashStrategy(HashStrategy hashStrategy) {
        this.hashStrategy = hashStrategy;
        return this;
    }

    @Override
    public HashStrategy getHashStrategy() {
        if (this.hashStrategy == null) {
            this.hashStrategy = new DefaultHashStrategy();
        }
        return this.hashStrategy;
    }

    @Override
    public MongoAuth setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.getHashStrategy().setAlgorithm(hashAlgorithm);
        return this;
    }

    public String toString() {
        return String.valueOf(this.hashStrategy);
    }
}

