/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.mongo.MongoAuthorization;
import io.vertx.ext.auth.mongo.MongoAuthorizationOptions;
import io.vertx.ext.mongo.MongoClient;
import java.util.Objects;

public class MongoAuthorizationImpl
implements MongoAuthorization {
    private static final Logger log = LoggerFactory.getLogger(MongoAuthorizationImpl.class);
    private final MongoClient mongoClient;
    private final String providerId;
    private final MongoAuthorizationOptions options;

    public MongoAuthorizationImpl(String providerId, MongoClient mongoClient, MongoAuthorizationOptions options) {
        this.providerId = Objects.requireNonNull(providerId);
        this.mongoClient = mongoClient;
        this.options = options;
    }

    protected JsonObject createQuery(String username) {
        return new JsonObject().put(this.options.getUsernameField(), (Object)username);
    }

    public String getId() {
        return this.providerId;
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Void>> handler) {
        this.getAuthorizations(user).onComplete(handler);
    }

    public Future<Void> getAuthorizations(User user) {
        JsonObject query = this.createQuery(user.principal().getString(this.options.getUsernameField()));
        return this.mongoClient.find(this.options.getCollectionName(), query).compose(res -> {
            for (JsonObject jsonObject : res) {
                JsonArray permissions;
                JsonArray roles = jsonObject.getJsonArray(this.options.getRoleField());
                if (roles != null) {
                    for (int i = 0; i < roles.size(); ++i) {
                        String role = roles.getString(i);
                        user.authorizations().add(this.providerId, (Authorization)RoleBasedAuthorization.create((String)role));
                    }
                }
                if ((permissions = jsonObject.getJsonArray(this.options.getPermissionField())) == null) continue;
                for (int i = 0; i < permissions.size(); ++i) {
                    String permission = permissions.getString(i);
                    user.authorizations().add(this.providerId, (Authorization)PermissionBasedAuthorization.create((String)permission));
                }
            }
            return Future.succeededFuture();
        });
    }
}

