/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo.impl;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.HashingStrategy;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import io.vertx.ext.auth.mongo.MongoAuthorizationOptions;
import io.vertx.ext.auth.mongo.MongoUserUtil;
import io.vertx.ext.mongo.MongoClient;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;

public class MongoUserUtilImpl
implements MongoUserUtil {
    private final MongoClient client;
    private final HashingStrategy strategy = HashingStrategy.load();
    private final SecureRandom random = new SecureRandom();
    private final MongoAuthenticationOptions authnOptions;
    private final MongoAuthorizationOptions authzOptions;

    public MongoUserUtilImpl(MongoClient client) {
        this(client, new MongoAuthenticationOptions(), new MongoAuthorizationOptions());
    }

    public MongoUserUtilImpl(MongoClient client, MongoAuthenticationOptions authnOptions, MongoAuthorizationOptions authzOptions) {
        this.client = client;
        this.authnOptions = authnOptions;
        this.authzOptions = authzOptions;
    }

    @Override
    public Future<String> createUser(String username, String password) {
        if (username == null || password == null) {
            return Future.failedFuture((String)"username or password are null");
        }
        byte[] salt = new byte[32];
        this.random.nextBytes(salt);
        return this.createHashedUser(username, this.strategy.hash("pbkdf2", null, Codec.base64Encode((byte[])salt), password));
    }

    @Override
    public Future<String> createHashedUser(String username, String hash) {
        if (username == null || hash == null) {
            return Future.failedFuture((String)"username or password hash are null");
        }
        return this.client.save(this.authnOptions.getCollectionName(), new JsonObject().put(this.authnOptions.getUsernameCredentialField(), (Object)username).put(this.authnOptions.getPasswordCredentialField(), (Object)hash));
    }

    @Override
    public Future<String> createUserRolesAndPermissions(String username, List<String> roles, List<String> permissions) {
        if (username == null) {
            return Future.failedFuture((String)"username is null");
        }
        return this.client.save(this.authzOptions.getCollectionName(), new JsonObject().put(this.authzOptions.getUsernameField(), (Object)username).put(this.authzOptions.getRoleField(), roles == null ? Collections.emptyList() : roles).put(this.authzOptions.getPermissionField(), permissions == null ? Collections.emptyList() : permissions));
    }
}

