/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import io.vertx.ext.auth.mongo.MongoAuthorizationOptions;
import io.vertx.ext.auth.mongo.impl.MongoUserUtilImpl;
import io.vertx.ext.mongo.MongoClient;
import java.util.List;

@VertxGen
public interface MongoUserUtil {
    public static MongoUserUtil create(MongoClient client) {
        return new MongoUserUtilImpl(client);
    }

    public static MongoUserUtil create(MongoClient client, MongoAuthenticationOptions authenticationOptions, MongoAuthorizationOptions authorizationOptions) {
        return new MongoUserUtilImpl(client, authenticationOptions, authorizationOptions);
    }

    @Fluent
    default public MongoUserUtil createUser(String username, String password, Handler<AsyncResult<String>> resultHandler) {
        this.createUser(username, password).onComplete(resultHandler);
        return this;
    }

    public Future<String> createUser(String var1, String var2);

    @Fluent
    default public MongoUserUtil createHashedUser(String username, String hash, Handler<AsyncResult<String>> resultHandler) {
        this.createHashedUser(username, hash).onComplete(resultHandler);
        return this;
    }

    public Future<String> createHashedUser(String var1, String var2);

    @Fluent
    default public MongoUserUtil createUserRolesAndPermissions(String username, List<String> roles, List<String> permissions, Handler<AsyncResult<String>> resultHandler) {
        this.createUserRolesAndPermissions(username, roles, permissions).onComplete(resultHandler);
        return this;
    }

    public Future<String> createUserRolesAndPermissions(String var1, List<String> var2, List<String> var3);
}

