/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo.impl;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.hashing.HashingStrategy;
import io.vertx.ext.auth.mongo.MongoAuthentication;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import io.vertx.ext.mongo.MongoClient;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MongoAuthenticationImpl
implements MongoAuthentication {
    private final HashingStrategy strategy = HashingStrategy.load();
    private final MongoClient mongoClient;
    private final MongoAuthenticationOptions options;

    public MongoAuthenticationImpl(MongoClient mongoClient, MongoAuthenticationOptions options) {
        this.mongoClient = mongoClient;
        this.options = options;
    }

    public Future<User> authenticate(Credentials credentials) {
        UsernamePasswordCredentials authInfo;
        if (credentials == null) {
            return Future.failedFuture((String)"Credentials must be set for authentication.");
        }
        try {
            authInfo = (UsernamePasswordCredentials)credentials;
            authInfo.checkValid(null);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
        AuthToken token = new AuthToken(authInfo.getUsername(), authInfo.getPassword());
        JsonObject query = this.createQuery(authInfo.getUsername());
        return this.mongoClient.find(this.options.getCollectionName(), query).compose(rows -> {
            try {
                User user = this.handleSelection((List<JsonObject>)rows, token);
                return Future.succeededFuture((Object)user);
            }
            catch (Exception e) {
                return Future.failedFuture((Throwable)e);
            }
        });
    }

    protected JsonObject createQuery(String username) {
        return new JsonObject().put(this.options.getUsernameField(), (Object)username);
    }

    private User handleSelection(List<JsonObject> resultList, AuthToken authToken) throws Exception {
        switch (resultList.size()) {
            case 0: {
                String message = "No account found for user [" + authToken.username + "]";
                throw new Exception(message);
            }
            case 1: {
                JsonObject json = resultList.get(0);
                User user = this.createUser(json);
                if (this.strategy.verify(json.getString(this.options.getPasswordField()), authToken.password)) {
                    return user;
                }
                String message = "Invalid username/password [" + authToken.username + "]";
                throw new Exception(message);
            }
        }
        String message = "More than one user row found for user [" + authToken.username + "( " + resultList.size() + " )]. Usernames must be unique.";
        throw new Exception(message);
    }

    private User createUser(JsonObject json) {
        User user = User.create((JsonObject)json);
        user.principal().put("amr", Collections.singletonList("pwd"));
        return user;
    }

    @Override
    public String hash(String id, Map<String, String> params, String salt, String password) {
        return this.strategy.hash(id, params, salt, password);
    }

    static class AuthToken {
        final String username;
        final String password;

        AuthToken(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

