/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.impl.AccessTokenImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;

public class ClientImpl
implements OAuth2Flow {
    private final Vertx vertx;
    private final JsonObject config;

    public ClientImpl(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
    }

    @Override
    public String authorizeURL(JsonObject params) {
        return null;
    }

    @Override
    public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> handler) {
        params.put("grant_type", "client_credentials");
        OAuth2API.api(this.vertx, this.config, HttpMethod.POST, this.config.getString("tokenPath"), params, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.succeeded()) {
                handler.handle((Object)Future.succeededFuture((Object)new AccessTokenImpl(this.vertx, this.config, (JsonObject)res.result())));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
    }
}

