/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.oauth2.providers;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;

/**
 * Simplified factory to create an  for Keycloak.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.KeycloakAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.auth.oauth2.providers.KeycloakAuth.class)
public class KeycloakAuth {

  public static final io.vertx.lang.rxjava.TypeArg<KeycloakAuth> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new KeycloakAuth((io.vertx.ext.auth.oauth2.providers.KeycloakAuth) obj),
    KeycloakAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.KeycloakAuth delegate;
  
  public KeycloakAuth(io.vertx.ext.auth.oauth2.providers.KeycloakAuth delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.KeycloakAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for Keycloak
   * @param vertx 
   * @param config the json config file exported from Keycloak admin console
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, JsonObject config) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Keycloak
   * @param vertx 
   * @param flow the oauth2 flow to use
   * @param config the json config file exported from Keycloak admin console
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow, JsonObject config) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), flow, config));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Keycloak
   * @param vertx 
   * @param config the json config file exported from Keycloak admin console
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, JsonObject config, HttpClientOptions httpClientOptions) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), config, httpClientOptions));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Keycloak
   * @param vertx 
   * @param flow the oauth2 flow to use
   * @param config the json config file exported from Keycloak admin console
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow, JsonObject config, HttpClientOptions httpClientOptions) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), flow, config, httpClientOptions));
    return ret;
  }


  public static KeycloakAuth newInstance(io.vertx.ext.auth.oauth2.providers.KeycloakAuth arg) {
    return arg != null ? new KeycloakAuth(arg) : null;
  }
}
