/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.reactivex.ext.auth.AuthProvider;

/**
 * AccessToken extension to the User interface
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.AccessToken original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.auth.oauth2.AccessToken.class)
public class AccessToken extends User {

  public static final io.vertx.lang.reactivex.TypeArg<AccessToken> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new AccessToken((io.vertx.ext.auth.oauth2.AccessToken) obj),
    AccessToken::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.AccessToken delegate;
  
  public AccessToken(io.vertx.ext.auth.oauth2.AccessToken delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.AccessToken getDelegate() {
    return delegate;
  }

  /**
   * Check if the access token is expired or not.
   * @return 
   */
  public boolean expired() { 
    boolean ret = delegate.expired();
    return ret;
  }

  /**
   * Refresh the access token
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken refresh(Handler<AsyncResult<Void>> callback) { 
    delegate.refresh(callback);
    return this;
  }

  /**
   * Refresh the access token
   * @return 
   */
  public Completable rxRefresh() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      refresh(handler);
    });
  }

  /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken revoke(String token_type, Handler<AsyncResult<Void>> callback) { 
    delegate.revoke(token_type, callback);
    return this;
  }

  /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   */
  public Completable rxRevoke(String token_type) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      revoke(token_type, handler);
    });
  }

  /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken logout(Handler<AsyncResult<Void>> callback) { 
    delegate.logout(callback);
    return this;
  }

  /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @return 
   */
  public Completable rxLogout() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      logout(handler);
    });
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public AccessToken introspect(Handler<AsyncResult<Void>> callback) { 
    delegate.introspect(callback);
    return this;
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @return 
   */
  public Completable rxIntrospect() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      introspect(handler);
    });
  }


  public static  AccessToken newInstance(io.vertx.ext.auth.oauth2.AccessToken arg) {
    return arg != null ? new AccessToken(arg) : null;
  }
}
