/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.providers;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth;
import io.vertx.core.http.HttpClientOptions;

/**
 * Simplified factory to create an  for CloudFoundry UAA.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth.class)
public class CloudFoundryAuth {

  public static final io.vertx.lang.reactivex.TypeArg<CloudFoundryAuth> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new CloudFoundryAuth((io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth) obj),
    CloudFoundryAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth delegate;
  
  public CloudFoundryAuth(io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for CloudFoundry UAA
   * @param vertx 
   * @param clientId the client id given to you by CloudFoundry UAA
   * @param clientSecret the client secret given to you by CloudFoundry UAA
   * @param uuaURL the url to your UUA server instance
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, String uuaURL) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth.create(vertx.getDelegate(), clientId, clientSecret, uuaURL));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for CloudFoundry UAA
   * @param vertx 
   * @param clientId the client id given to you by CloudFoundry UAA
   * @param clientSecret the client secret given to you by CloudFoundry UAA
   * @param uuaURL the url to your UUA server instance
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, String uuaURL, HttpClientOptions httpClientOptions) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth.create(vertx.getDelegate(), clientId, clientSecret, uuaURL, httpClientOptions));
    return ret;
  }


  public static  CloudFoundryAuth newInstance(io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth arg) {
    return arg != null ? new CloudFoundryAuth(arg) : null;
  }
}
