/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.providers;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth;
import io.vertx.core.http.HttpClientOptions;

/**
 * Simplified factory to create an  for LinkedIn.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.LinkedInAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.auth.oauth2.providers.LinkedInAuth.class)
public class LinkedInAuth {

  public static final io.vertx.lang.reactivex.TypeArg<LinkedInAuth> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new LinkedInAuth((io.vertx.ext.auth.oauth2.providers.LinkedInAuth) obj),
    LinkedInAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.LinkedInAuth delegate;
  
  public LinkedInAuth(io.vertx.ext.auth.oauth2.providers.LinkedInAuth delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.LinkedInAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for LinkedIn
   * @param vertx 
   * @param clientId the client id given to you by LinkedIn
   * @param clientSecret the client secret given to you by LinkedIn
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.LinkedInAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for LinkedIn
   * @param vertx 
   * @param clientId the client id given to you by LinkedIn
   * @param clientSecret the client secret given to you by LinkedIn
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, HttpClientOptions httpClientOptions) { 
    OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.LinkedInAuth.create(vertx.getDelegate(), clientId, clientSecret, httpClientOptions));
    return ret;
  }


  public static  LinkedInAuth newInstance(io.vertx.ext.auth.oauth2.providers.LinkedInAuth arg) {
    return arg != null ? new LinkedInAuth(arg) : null;
  }
}
